/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.accessor;

import com.aliyun.akless.idprovider.errors.IdpErrorCode;
import com.aliyun.akless.idprovider.errors.IdpException;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.RetryException;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.Retryer;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.RetryerBuilder;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.StopStrategies;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.WaitStrategies;
import com.aliyun.akless.idprovider.shaded.io.grpc.ConnectivityState;
import com.aliyun.akless.idprovider.shaded.io.grpc.ManagedChannel;
import com.aliyun.akless.idprovider.utils.ExceptionUtil;
import com.aliyun.akless.idprovider.utils.config.Config;
import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public abstract class UdsChannel {
    protected ManagedChannel channel;
    private static final Retryer<ConnectivityState> connRetryer = RetryerBuilder.newBuilder().retryIfResult(state -> !ConnectivityState.READY.equals(state)).withStopStrategy(StopStrategies.stopAfterDelay(Config.GRPC_CONN_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS)).withWaitStrategy(WaitStrategies.fixedWait(100L, TimeUnit.MILLISECONDS)).build();

    protected UdsChannel(String serviceName, File sockFile) throws Exception {
        try {
            this.channel = this.buildChannel(serviceName, sockFile);
            this.checkConnState(serviceName);
        }
        catch (Exception e) {
            this.shutdown();
            throw e;
        }
    }

    protected abstract ManagedChannel buildChannel(String var1, File var2) throws Exception;

    protected void checkConnState(String serviceName) {
        try {
            this.channel.resetConnectBackoff();
            connRetryer.call(() -> this.channel.getState(true));
        }
        catch (RetryException | ExecutionException e) {
            throw new IdpException(IdpErrorCode.GRPC_SERVICE_NOT_READY, serviceName, ExceptionUtil.normalizeRetryException(e).getMessage());
        }
    }

    public void shutdown() {
        if (this.channel != null) {
            this.channel.shutdown();
        }
    }

    public ManagedChannel getChannel() {
        return this.channel;
    }
}

