/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.accessor;

import com.aliyun.akless.idprovider.accessor.IAccessor;
import com.aliyun.akless.idprovider.accessor.NettyNativeChannel;
import com.aliyun.akless.idprovider.accessor.OkHttpChannel;
import com.aliyun.akless.idprovider.accessor.UdsChannel;
import com.aliyun.akless.idprovider.accessor.config.RequestConfig;
import com.aliyun.akless.idprovider.enums.IdpHealthResult;
import com.aliyun.akless.idprovider.enums.IdpHealthStatus;
import com.aliyun.akless.idprovider.enums.NetworkType;
import com.aliyun.akless.idprovider.enums.TokenCredType;
import com.aliyun.akless.idprovider.errors.IdpErrorCode;
import com.aliyun.akless.idprovider.errors.IdpException;
import com.aliyun.akless.idprovider.model.CaCerts;
import com.aliyun.akless.idprovider.model.EnvConfig;
import com.aliyun.akless.idprovider.model.OIDCToken;
import com.aliyun.akless.idprovider.model.TokenFactor;
import com.aliyun.akless.idprovider.proto.secrets.SecretsGrpc;
import com.aliyun.akless.idprovider.proto.secrets.SecretsOuterClass;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.Retryer;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.RetryerBuilder;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.StopStrategies;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.WaitStrategies;
import com.aliyun.akless.idprovider.shaded.io.grpc.Status;
import com.aliyun.akless.idprovider.shaded.io.grpc.StatusRuntimeException;
import com.aliyun.akless.idprovider.utils.ExceptionUtil;
import com.aliyun.akless.idprovider.utils.NetUtil;
import com.aliyun.akless.idprovider.utils.StringUtil;
import com.aliyun.akless.idprovider.utils.config.Config;
import java.io.File;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretAccessor
implements IAccessor {
    private static final Logger logger = LoggerFactory.getLogger(SecretAccessor.class);
    private static final Retryer<Object> accessorRetryer = RetryerBuilder.newBuilder().retryIfException(e -> e instanceof StatusRuntimeException && (((StatusRuntimeException)e).getStatus().getCode().equals((Object)Status.Code.UNAVAILABLE) || ((StatusRuntimeException)e).getStatus().getCode().equals((Object)Status.Code.DEADLINE_EXCEEDED))).withStopStrategy(StopStrategies.stopAfterDelay(Config.GRPC_SVC_ACCESS_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS)).withWaitStrategy(WaitStrategies.exponentialWait(100L, Config.GRPC_SVC_ACCESS_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS)).build();
    private final UdsChannel channel;
    private final SecretsGrpc.SecretsBlockingStub blockingStub;
    private static final String defaultSockPath = "/trusted-provider/trusted-provider.sock";
    private static final String authServerOxsRegionEndpoint = "app-idp-inner.%s.aliyuncs.com";
    private static final String stsVpcRegionEndpoint = "sts-vpc.%s.aliyuncs.com";

    public SecretAccessor() throws Exception {
        UdsChannel udsChannel;
        File socketFile = SecretAccessor.getSockFile();
        try {
            udsChannel = new OkHttpChannel("trusted-provider", socketFile);
        }
        catch (NoClassDefFoundError | SocketException e) {
            logger.warn("failed to create grpc channel against trusted provider via junixsocket: {}", (Object)e.getMessage());
            udsChannel = new NettyNativeChannel("trusted-provider", socketFile);
        }
        catch (Exception e) {
            logger.warn("failed to create grpc channel: {}", (Object)e.getMessage());
            throw new IdpException(IdpErrorCode.CREATE_GRPC_CHANNEL_FAILED, e.getMessage());
        }
        this.channel = udsChannel;
        this.blockingStub = SecretsGrpc.newBlockingStub(this.channel.getChannel());
        logger.info("succeed to create secrets accessor with unix socket path {}", (Object)socketFile.getAbsolutePath());
    }

    @Override
    public EnvConfig initEnvConfig(RequestConfig reqConfig, String regionId, String namespace, String appName, String appGroup, String appEnv, String bootstrapToken) throws Exception {
        String hostName;
        String envVar;
        String effectiveRegionId = "";
        String effectiveAppName = "";
        String effectiveAppGroup = "";
        String effectiveAppEnv = "";
        String networkType = "";
        String effectiveCloudType = "public";
        String effectiveBaseDomain = "aliyun";
        try {
            SecretsOuterClass.GetAppMetaInfoRequest request = SecretsOuterClass.GetAppMetaInfoRequest.newBuilder().build();
            SecretsOuterClass.GetAppMetaInfoResponse response = ((SecretsGrpc.SecretsBlockingStub)this.blockingStub.withDeadlineAfter(reqConfig.getTimeoutMillis(), TimeUnit.MILLISECONDS)).getAppMetaInfo(request);
            if (!response.getError().isEmpty()) {
                throw new RuntimeException(response.getError());
            }
            effectiveRegionId = SecretAccessor.trimRegionId(response.getRegion());
            effectiveAppName = response.getName();
            effectiveAppGroup = response.getGroup();
            effectiveAppEnv = response.getEnv();
            networkType = response.getNetwork();
            effectiveCloudType = StringUtil.isEmpty(response.getCloudType()) ? effectiveCloudType : response.getCloudType();
            effectiveBaseDomain = StringUtil.isEmpty(response.getBaseDomain()) ? effectiveBaseDomain : response.getBaseDomain();
        }
        catch (Exception e) {
            logger.warn("failed to get required configs from trusted provider: {}", (Object)e.getMessage());
        }
        if (StringUtil.isEmpty(effectiveRegionId)) {
            envVar = "TRUSTED_PROVIDER_REGION";
            effectiveRegionId = System.getenv(envVar);
            if (StringUtil.isEmpty(effectiveRegionId)) {
                throw new IdpException(IdpErrorCode.INIT_ENV_CONFIG_FAILED, String.format("region id not found in env variable %s", envVar));
            }
            effectiveRegionId = SecretAccessor.trimRegionId(effectiveRegionId);
        }
        if (StringUtil.isEmpty(effectiveAppName) && StringUtil.isEmpty(effectiveAppName = System.getenv(envVar = "SIGMA_APP_NAME"))) {
            throw new IdpException(IdpErrorCode.INIT_ENV_CONFIG_FAILED, String.format("app name not found in env variable %s", envVar));
        }
        if (StringUtil.isEmpty(effectiveAppGroup) && StringUtil.isEmpty(effectiveAppGroup = System.getenv(envVar = "SIGMA_APP_GROUP"))) {
            throw new IdpException(IdpErrorCode.INIT_ENV_CONFIG_FAILED, String.format("app group not found in env variable %s", envVar));
        }
        if (StringUtil.isEmpty(effectiveAppEnv) && StringUtil.isEmpty(effectiveAppEnv = System.getenv(envVar = "SIGMA_APP_STAGE"))) {
            throw new IdpException(IdpErrorCode.INIT_ENV_CONFIG_FAILED, String.format("app env not found in env variable %s", envVar));
        }
        if (StringUtil.isEmpty(networkType)) {
            if (NetUtil.checkUrlReachable(String.format(authServerOxsRegionEndpoint, effectiveRegionId), 443)) {
                networkType = NetworkType.ALIYUN_NET_OXS.getType();
            } else if (NetUtil.checkUrlReachable(String.format(stsVpcRegionEndpoint, effectiveRegionId), 443)) {
                networkType = NetworkType.ALIYUN_NET_VPC.getType();
            } else {
                throw new IdpException(IdpErrorCode.INIT_ENV_CONFIG_FAILED, "failed to retrieve network type with all possible detection methods");
            }
        }
        try {
            InetAddress host = InetAddress.getLocalHost();
            hostName = host.getHostName();
        }
        catch (UnknownHostException e) {
            hostName = "unknown host";
        }
        return new EnvConfig(effectiveRegionId, networkType, effectiveAppName, effectiveAppGroup, effectiveAppEnv, hostName, "aone", effectiveCloudType, effectiveBaseDomain);
    }

    @Override
    public OIDCToken getIDToken(RequestConfig reqConfig, TokenFactor factor) throws Exception {
        return this.getIDTokenInternal(reqConfig, factor, false);
    }

    @Override
    public OIDCToken refreshIDToken(RequestConfig reqConfig, TokenFactor factor) throws Exception {
        return this.getIDTokenInternal(reqConfig, factor, true);
    }

    @Override
    public OIDCToken getIDTokenOnBehalf(RequestConfig reqConfig, TokenCredType sourceCredentialType, String sourceCredential, TokenFactor factor, boolean forceRefresh) throws Exception {
        SecretsOuterClass.SourceCredentialType credType;
        try {
            credType = SecretsOuterClass.SourceCredentialType.forNumber(sourceCredentialType.getCode());
        }
        catch (IllegalArgumentException e) {
            throw new IdpException(IdpErrorCode.ILLEGAL_PARAM, String.format("unsupported credential type %s", sourceCredentialType.getType()));
        }
        try {
            SecretsOuterClass.GetIDTokenOnBehalfRequest.Builder requestBuilder = SecretsOuterClass.GetIDTokenOnBehalfRequest.newBuilder().setSourceCredentialType(credType).setSourceCredential(sourceCredential).setTargetService(factor.getTargetService()).setForceRefresh(forceRefresh);
            SecretsOuterClass.GetIDTokenResponse response = (SecretsOuterClass.GetIDTokenResponse)accessorRetryer.call(() -> ((SecretsGrpc.SecretsBlockingStub)this.blockingStub.withDeadlineAfter(reqConfig.getTimeoutMillis(), TimeUnit.MILLISECONDS)).getIDTokenOnBehalf(requestBuilder.build()));
            if (!response.getError().isEmpty()) {
                throw new RuntimeException(response.getError());
            }
            return new OIDCToken(response.getToken());
        }
        catch (Exception e) {
            Exception normalizedException = ExceptionUtil.normalizeRetryException(e);
            logger.error("failed to get idtoken on behalf: {}", (Object)normalizedException.getMessage());
            throw normalizedException;
        }
    }

    @Override
    public OIDCToken getIDTokenOnAssumptionForApp(RequestConfig reqConfig, String sourceNamespace, String sourceAppName, String sourceAppGroup, String sourceAppEnv, TokenFactor factor, boolean forceRefresh) throws Exception {
        try {
            SecretsOuterClass.GetIDTokenOnAssumptionRequest.Builder requestBuilder = SecretsOuterClass.GetIDTokenOnAssumptionRequest.newBuilder().setSourceNamespace(sourceNamespace).setSourceAppName(sourceAppName).setSourceAppGroup(sourceAppGroup).setSourceAppEnv(sourceAppEnv).setTargetService(factor.getTargetService()).setForceRefresh(forceRefresh);
            SecretsOuterClass.GetIDTokenResponse response = (SecretsOuterClass.GetIDTokenResponse)accessorRetryer.call(() -> ((SecretsGrpc.SecretsBlockingStub)this.blockingStub.withDeadlineAfter(reqConfig.getTimeoutMillis(), TimeUnit.MILLISECONDS)).getIDTokenOnAssumption(requestBuilder.build()));
            if (!response.getError().isEmpty()) {
                throw new RuntimeException(response.getError());
            }
            return new OIDCToken(response.getToken());
        }
        catch (Exception e) {
            Exception normalizedException = ExceptionUtil.normalizeRetryException(e);
            logger.error("failed to get idtoken on assumption for application: {}", (Object)normalizedException.getMessage());
            throw normalizedException;
        }
    }

    @Override
    public OIDCToken getIDTokenOnAssumptionForEmp(RequestConfig reqConfig, String empId, TokenFactor factor, boolean forceRefresh) throws Exception {
        try {
            SecretsOuterClass.GetIDTokenOnAssumptionForEmpRequest.Builder requestBuilder = SecretsOuterClass.GetIDTokenOnAssumptionForEmpRequest.newBuilder().setEmpId(empId).setTargetService(factor.getTargetService()).setForceRefresh(forceRefresh);
            SecretsOuterClass.GetIDTokenResponse response = (SecretsOuterClass.GetIDTokenResponse)accessorRetryer.call(() -> ((SecretsGrpc.SecretsBlockingStub)this.blockingStub.withDeadlineAfter(reqConfig.getTimeoutMillis(), TimeUnit.MILLISECONDS)).getIDTokenOnAssumptionForEmp(requestBuilder.build()));
            if (!response.getError().isEmpty()) {
                throw new RuntimeException(response.getError());
            }
            return new OIDCToken(response.getToken());
        }
        catch (Exception e) {
            Exception normalizedException = ExceptionUtil.normalizeRetryException(e);
            logger.error("failed to get idtoken on assumption for employee: {}", (Object)normalizedException.getMessage());
            throw normalizedException;
        }
    }

    @Override
    public CaCerts getCerts(RequestConfig reqConfig, String caller, boolean forceRefresh) throws Exception {
        try {
            SecretsOuterClass.GetCertsRequest.Builder requestBuilder = SecretsOuterClass.GetCertsRequest.newBuilder().setCaller(caller).setForceRefresh(forceRefresh);
            SecretsOuterClass.GetCertsResponse response = (SecretsOuterClass.GetCertsResponse)accessorRetryer.call(() -> ((SecretsGrpc.SecretsBlockingStub)this.blockingStub.withDeadlineAfter(reqConfig.getTimeoutMillis(), TimeUnit.MILLISECONDS)).getCerts(requestBuilder.build()));
            if (!response.getError().isEmpty()) {
                throw new RuntimeException(response.getError());
            }
            return new CaCerts(response.getKeyCertChain().toByteArray(), response.getPrivateKey().toByteArray(), response.getTrustedCerts().toByteArray());
        }
        catch (Exception e) {
            Exception normalizedException = ExceptionUtil.normalizeRetryException(e);
            logger.error("failed to get certs: {}", (Object)normalizedException.getMessage());
            throw normalizedException;
        }
    }

    private OIDCToken getIDTokenInternal(RequestConfig reqConfig, TokenFactor factor, boolean forceRefresh) throws Exception {
        SecretsOuterClass.SignAlgorithm alg;
        try {
            alg = SecretsOuterClass.SignAlgorithm.forNumber(factor.getSignAlg().getCode());
        }
        catch (IllegalArgumentException ignored) {
            throw new IdpException(IdpErrorCode.ILLEGAL_PARAM, String.format("unsupported sign algorithm %s", factor.getSignAlg().getAlg()));
        }
        try {
            SecretsOuterClass.GetIDTokenRequest request = SecretsOuterClass.GetIDTokenRequest.newBuilder().setSignAlgorithm(alg).setTargetService(factor.getTargetService()).setForceRefresh(forceRefresh).build();
            SecretsOuterClass.GetIDTokenResponse response = (SecretsOuterClass.GetIDTokenResponse)accessorRetryer.call(() -> ((SecretsGrpc.SecretsBlockingStub)this.blockingStub.withDeadlineAfter(reqConfig.getTimeoutMillis(), TimeUnit.MILLISECONDS)).getIDToken(request));
            if (!response.getError().isEmpty()) {
                throw new RuntimeException(response.getError());
            }
            return new OIDCToken(response.getToken());
        }
        catch (Exception e) {
            Exception normalizedException = ExceptionUtil.normalizeRetryException(e);
            logger.error("failed to get token with force refresh {}: {}", (Object)(forceRefresh ? "enabled" : "disabled"), (Object)normalizedException.getMessage());
            throw normalizedException;
        }
    }

    @Override
    public IdpHealthResult checkHealth(boolean reConn) {
        return new IdpHealthResult(IdpHealthStatus.IDP_UP_TO_DATE, "up-to-date");
    }

    @Override
    public void exitPeer() throws Exception {
        throw new IdpException(IdpErrorCode.UNSUPPORTED_METHOD, "exitPeer not supported by trusted provider");
    }

    @Override
    public void shutdown() {
        if (this.channel != null) {
            this.channel.shutdown();
        }
    }

    public static File getSockFile() throws IdpException {
        String sockPath = null;
        try {
            String envSockPath = System.getenv("TRUSTED_PROVIDER_SOCKET_PATH");
            sockPath = envSockPath == null ? defaultSockPath : envSockPath;
        }
        catch (SecurityException ex) {
            sockPath = defaultSockPath;
        }
        File socketFile = new File(sockPath);
        if (!socketFile.exists()) {
            throw new IdpException(IdpErrorCode.GRPC_SERVICE_NOT_READY, "trusted-provider", String.format("no available unix socket found on %s", sockPath));
        }
        return socketFile;
    }

    public static boolean checkSockFile() {
        try {
            SecretAccessor.getSockFile();
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private static String trimRegionId(String rawRegionId) {
        String suffix = "-oxs";
        return rawRegionId.endsWith(suffix) ? rawRegionId.substring(0, rawRegionId.length() - suffix.length()) : rawRegionId;
    }
}

