/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.accessor;

import com.aliyun.akless.idprovider.accessor.UdsChannel;
import com.aliyun.akless.idprovider.errors.IdpErrorCode;
import com.aliyun.akless.idprovider.errors.IdpException;
import com.aliyun.akless.idprovider.shaded.io.grpc.ManagedChannel;
import com.aliyun.akless.idprovider.shaded.io.grpc.netty.NettyChannelBuilder;
import com.aliyun.akless.idprovider.shaded.io.netty.channel.MultithreadEventLoopGroup;
import com.aliyun.akless.idprovider.shaded.io.netty.channel.epoll.Epoll;
import com.aliyun.akless.idprovider.shaded.io.netty.channel.epoll.EpollDomainSocketChannel;
import com.aliyun.akless.idprovider.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import com.aliyun.akless.idprovider.shaded.io.netty.channel.kqueue.KQueue;
import com.aliyun.akless.idprovider.shaded.io.netty.channel.kqueue.KQueueDomainSocketChannel;
import com.aliyun.akless.idprovider.shaded.io.netty.channel.kqueue.KQueueEventLoopGroup;
import com.aliyun.akless.idprovider.shaded.io.netty.channel.unix.DomainSocketAddress;
import com.aliyun.akless.idprovider.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import java.io.File;

public class NettyNativeChannel
extends UdsChannel {
    private MultithreadEventLoopGroup elg;

    public NettyNativeChannel(String serviceName, File sockFile) throws Exception {
        super(serviceName, sockFile);
    }

    @Override
    protected ManagedChannel buildChannel(String serviceName, File sockFile) throws IdpException {
        DomainSocketAddress address = new DomainSocketAddress(sockFile);
        NettyChannelBuilder builder = NettyChannelBuilder.forAddress(address).usePlaintext();
        DefaultThreadFactory tf = new DefaultThreadFactory("akless-idp-accessor", true);
        if (Epoll.isAvailable()) {
            this.elg = new EpollEventLoopGroup(tf);
            return builder.channelType(EpollDomainSocketChannel.class).eventLoopGroup(this.elg).build();
        }
        if (KQueue.isAvailable()) {
            this.elg = new KQueueEventLoopGroup(tf);
            return builder.channelType(KQueueDomainSocketChannel.class).eventLoopGroup(this.elg).build();
        }
        throw new IdpException(IdpErrorCode.UNSUPPORTED_PLATFORM, String.format("[%s] (1) %s; (2) %s", serviceName, Epoll.unavailabilityCause().getMessage(), KQueue.unavailabilityCause().getMessage()));
    }

    @Override
    public void shutdown() {
        if (this.elg != null) {
            this.elg.shutdownGracefully();
        }
        super.shutdown();
    }
}

