/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.accessor;

import com.aliyun.akless.idprovider.accessor.IAccessor;
import com.aliyun.akless.idprovider.accessor.NettyNativeChannel;
import com.aliyun.akless.idprovider.accessor.OkHttpChannel;
import com.aliyun.akless.idprovider.accessor.UdsChannel;
import com.aliyun.akless.idprovider.accessor.config.RequestConfig;
import com.aliyun.akless.idprovider.enums.IdpHealthResult;
import com.aliyun.akless.idprovider.enums.IdpHealthStatus;
import com.aliyun.akless.idprovider.enums.TokenCredType;
import com.aliyun.akless.idprovider.errors.IdpErrorCode;
import com.aliyun.akless.idprovider.errors.IdpException;
import com.aliyun.akless.idprovider.model.CaCerts;
import com.aliyun.akless.idprovider.model.EnvConfig;
import com.aliyun.akless.idprovider.model.OIDCToken;
import com.aliyun.akless.idprovider.model.TokenFactor;
import com.aliyun.akless.idprovider.proto.idprovider.ControllerServiceGrpc;
import com.aliyun.akless.idprovider.proto.idprovider.IdpServiceGrpc;
import com.aliyun.akless.idprovider.proto.idprovider.Idprovider;
import com.aliyun.akless.idprovider.proto.idproviderv0.ControllerServiceGrpc;
import com.aliyun.akless.idprovider.proto.idproviderv0.IdproviderV0;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.Retryer;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.RetryerBuilder;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.StopStrategies;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.WaitStrategies;
import com.aliyun.akless.idprovider.shaded.io.grpc.ConnectivityState;
import com.aliyun.akless.idprovider.shaded.io.grpc.Status;
import com.aliyun.akless.idprovider.shaded.io.grpc.StatusRuntimeException;
import com.aliyun.akless.idprovider.utils.ExceptionUtil;
import com.aliyun.akless.idprovider.utils.FileUtil;
import com.aliyun.akless.idprovider.utils.JwtUtil;
import com.aliyun.akless.idprovider.utils.ProcUtil;
import com.aliyun.akless.idprovider.utils.config.Config;
import java.io.File;
import java.net.SocketException;
import java.nio.file.Paths;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdpAccessor
implements IAccessor {
    private static final Logger logger = LoggerFactory.getLogger(IdpAccessor.class);
    private static final Retryer<Object> svcAccessorRetryer = RetryerBuilder.newBuilder().retryIfException(e -> e instanceof StatusRuntimeException && (((StatusRuntimeException)e).getStatus().getCode().equals((Object)Status.Code.UNAVAILABLE) || ((StatusRuntimeException)e).getStatus().getCode().equals((Object)Status.Code.DEADLINE_EXCEEDED))).withStopStrategy(StopStrategies.stopAfterDelay(Config.GRPC_SVC_ACCESS_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS)).withWaitStrategy(WaitStrategies.exponentialWait(100L, Config.GRPC_SVC_ACCESS_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS)).build();
    private static final Retryer<ConnectivityState> channelStateChecker = RetryerBuilder.newBuilder().retryIfResult(result -> result == ConnectivityState.READY).withStopStrategy(StopStrategies.stopAfterDelay(Config.GRPC_EXIT_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS)).withWaitStrategy(WaitStrategies.fixedWait(100L, TimeUnit.MILLISECONDS)).build();
    private final File socketFile;
    private final UdsChannel channel;
    private final IdpServiceGrpc.IdpServiceBlockingStub blockingServiceStub;
    private final ControllerServiceGrpc.ControllerServiceBlockingStub blockingCtrlStub;
    private final ControllerServiceGrpc.ControllerServiceBlockingStub blockingCtrlStubV0;
    private final CacheEnvConfig cacheEnvConfig = new CacheEnvConfig();
    private final CacheToken cacheToken = new CacheToken();
    private static final String defaultSockName = ".akless_idp.sock";
    private static final String idpServerVersion = "0.6.2";

    public IdpAccessor() throws Exception {
        UdsChannel udsChannel;
        this.socketFile = IdpAccessor.getSockFile();
        try {
            udsChannel = new OkHttpChannel("idp-server", this.socketFile);
        }
        catch (NoClassDefFoundError | SocketException e) {
            logger.warn("failed to create grpc channel against idp server via junixsocket: {}", (Object)e.getMessage());
            udsChannel = new NettyNativeChannel("idp-server", this.socketFile);
        }
        catch (Exception e) {
            logger.warn("failed to create grpc channel: {}", (Object)e.getMessage());
            throw new IdpException(IdpErrorCode.CREATE_GRPC_CHANNEL_FAILED, e.getMessage());
        }
        this.channel = udsChannel;
        this.blockingServiceStub = IdpServiceGrpc.newBlockingStub(this.channel.getChannel());
        this.blockingCtrlStub = ControllerServiceGrpc.newBlockingStub(this.channel.getChannel());
        this.blockingCtrlStubV0 = com.aliyun.akless.idprovider.proto.idproviderv0.ControllerServiceGrpc.newBlockingStub(this.channel.getChannel());
        logger.info("succeed to create idp accessor with unix socket path {}", (Object)this.socketFile.getAbsolutePath());
    }

    @Override
    public EnvConfig initEnvConfig(RequestConfig reqConfig, String regionId, String namespace, String appName, String appGroup, String appEnv, String bootstrapToken) throws Exception {
        try {
            Idprovider.InitEnvConfigRequest request = Idprovider.InitEnvConfigRequest.newBuilder().setEnvConfig(Idprovider.EnvConfig.newBuilder().setRegionId(regionId).setNamespace(namespace).setAppName(appName).setAppGroup(appGroup).setAppEnv(appEnv).setBootstrapToken(bootstrapToken).build()).build();
            Idprovider.InitEnvConfigResponse response = (Idprovider.InitEnvConfigResponse)svcAccessorRetryer.call(() -> ((IdpServiceGrpc.IdpServiceBlockingStub)this.blockingServiceStub.withDeadlineAfter(reqConfig.getTimeoutMillis(), TimeUnit.MILLISECONDS)).initEnvConfig(request));
            this.cacheEnvConfig.update(new EnvConfig(response.getRegionId(), response.getNetworkType(), response.getAppName(), response.getAppGroup(), response.getAppEnv(), response.getInstanceId(), response.getNamespace(), response.getBootstrapToken(), response.getCloudType(), response.getBaseDomain()));
            if (!"office".equals(response.getNetworkType()) && !regionId.equals(response.getRegionId())) {
                logger.warn("input region-id {} was not consistent with what detected from current environment {}", (Object)regionId, (Object)response.getRegionId());
            }
        }
        catch (Exception e) {
            Exception normalizedException = ExceptionUtil.normalizeRetryException(e);
            if (this.cacheEnvConfig.get() == null) {
                logger.error("failed to init env config: {}", (Object)normalizedException.getMessage());
                throw normalizedException;
            }
            logger.warn("failed to init env config: {}, use cached config instead", (Object)normalizedException.getMessage());
        }
        return this.cacheEnvConfig.get();
    }

    @Override
    public OIDCToken getIDToken(RequestConfig reqConfig, TokenFactor factor) throws Exception {
        Idprovider.SignAlg alg;
        try {
            alg = Idprovider.SignAlg.forNumber(factor.getSignAlg().getCode());
        }
        catch (IllegalArgumentException ignored) {
            throw new IdpException(IdpErrorCode.ILLEGAL_PARAM, String.format("unsupported sign algorithm %s", factor.getSignAlg().getAlg()));
        }
        try {
            Idprovider.GetIDTokenRequest.Builder requestBuilder = Idprovider.GetIDTokenRequest.newBuilder().setSignAlg(alg).setTargetService(factor.getTargetService());
            EnvConfig envConfig = this.cacheEnvConfig.get();
            if (envConfig != null) {
                requestBuilder.setEnvConfig(Idprovider.EnvConfig.newBuilder().setRegionId(envConfig.getRegionId()).setNamespace(envConfig.getNamespace()).setAppName(envConfig.getAppName()).setAppGroup(envConfig.getAppGroup()).setAppEnv(envConfig.getAppEnv()).setBootstrapToken(envConfig.getBootstrapToken()).setNetworkType(envConfig.getNetworkType()).build());
            }
            Idprovider.TokenResponse response = (Idprovider.TokenResponse)svcAccessorRetryer.call(() -> ((IdpServiceGrpc.IdpServiceBlockingStub)this.blockingServiceStub.withDeadlineAfter(reqConfig.getTimeoutMillis(), TimeUnit.MILLISECONDS)).getIDToken(requestBuilder.build()));
            this.cacheToken.update(factor, response);
        }
        catch (Exception e) {
            Exception normalizedException = ExceptionUtil.normalizeRetryException(e);
            if (this.cacheToken.get(factor) == null) {
                logger.error("failed to get token: {}", (Object)normalizedException.getMessage());
                if (normalizedException.getMessage().contains("MismatchParam")) {
                    this.cacheEnvConfig.clearEnvConfig();
                }
                throw normalizedException;
            }
            logger.warn("failed to get token: {}, use cached token instead", (Object)normalizedException.getMessage());
        }
        return this.cacheToken.get(factor);
    }

    @Override
    public OIDCToken refreshIDToken(RequestConfig reqConfig, TokenFactor factor) throws Exception {
        Idprovider.SignAlg alg;
        try {
            alg = Idprovider.SignAlg.forNumber(factor.getSignAlg().getCode());
        }
        catch (IllegalArgumentException ignored) {
            throw new IdpException(IdpErrorCode.ILLEGAL_PARAM, String.format("unsupported sign algorithm %s", factor.getSignAlg().getAlg()));
        }
        try {
            Idprovider.RefreshIDTokenRequest.Builder requestBuilder = Idprovider.RefreshIDTokenRequest.newBuilder().setSignAlg(alg).setTargetService(factor.getTargetService());
            EnvConfig envConfig = this.cacheEnvConfig.get();
            if (envConfig != null) {
                requestBuilder.setEnvConfig(Idprovider.EnvConfig.newBuilder().setRegionId(envConfig.getRegionId()).setNamespace(envConfig.getNamespace()).setAppName(envConfig.getAppName()).setAppGroup(envConfig.getAppGroup()).setAppEnv(envConfig.getAppEnv()).setBootstrapToken(envConfig.getBootstrapToken()).setNetworkType(envConfig.getNetworkType()).build());
            }
            Idprovider.TokenResponse response = (Idprovider.TokenResponse)svcAccessorRetryer.call(() -> ((IdpServiceGrpc.IdpServiceBlockingStub)this.blockingServiceStub.withDeadlineAfter(reqConfig.getTimeoutMillis(), TimeUnit.MILLISECONDS)).refreshIDToken(requestBuilder.build()));
            this.cacheToken.update(factor, response);
            return this.cacheToken.get(factor);
        }
        catch (Exception e) {
            Exception normalizedException = ExceptionUtil.normalizeRetryException(e);
            if (this.cacheToken.get(factor) == null && normalizedException.getMessage().contains("MismatchParam")) {
                this.cacheEnvConfig.clearEnvConfig();
            }
            logger.error("failed to refresh token: {}", (Object)normalizedException.getMessage());
            throw normalizedException;
        }
    }

    @Override
    public OIDCToken getIDTokenOnBehalf(RequestConfig reqConfig, TokenCredType sourceCredentialType, String sourceCredential, TokenFactor factor, boolean forceRefresh) throws Exception {
        Idprovider.SourceCredentialType credType;
        try {
            credType = Idprovider.SourceCredentialType.forNumber(sourceCredentialType.getCode());
        }
        catch (IllegalArgumentException e) {
            throw new IdpException(IdpErrorCode.ILLEGAL_PARAM, String.format("unsupported credential type %s", sourceCredentialType.getType()));
        }
        try {
            Idprovider.GetIDTokenOnBehalfRequest.Builder requestBuilder = Idprovider.GetIDTokenOnBehalfRequest.newBuilder().setSourceCredentialType(credType).setSourceCredential(sourceCredential).setTargetService(factor.getTargetService()).setForceRefresh(forceRefresh);
            EnvConfig envConfig = this.cacheEnvConfig.get();
            if (envConfig != null) {
                requestBuilder.setEnvConfig(Idprovider.EnvConfig.newBuilder().setRegionId(envConfig.getRegionId()).setNamespace(envConfig.getNamespace()).setAppName(envConfig.getAppName()).setAppGroup(envConfig.getAppGroup()).setAppEnv(envConfig.getAppEnv()).setBootstrapToken(envConfig.getBootstrapToken()).setNetworkType(envConfig.getNetworkType()).build());
            }
            Idprovider.TokenResponse response = (Idprovider.TokenResponse)svcAccessorRetryer.call(() -> ((IdpServiceGrpc.IdpServiceBlockingStub)this.blockingServiceStub.withDeadlineAfter(reqConfig.getTimeoutMillis(), TimeUnit.MILLISECONDS)).getIDTokenOnBehalf(requestBuilder.build()));
            return new OIDCToken(response.getPrimaryToken());
        }
        catch (Exception e) {
            Exception normalizedException = ExceptionUtil.normalizeRetryException(e);
            if (normalizedException.getMessage().contains("MismatchParam")) {
                this.cacheEnvConfig.clearEnvConfig();
            }
            logger.error("failed to get idtoken on behalf: {}", (Object)normalizedException.getMessage());
            throw normalizedException;
        }
    }

    @Override
    public OIDCToken getIDTokenOnAssumptionForApp(RequestConfig reqConfig, String sourceNamespace, String sourceAppName, String sourceAppGroup, String sourceAppEnv, TokenFactor factor, boolean forceRefresh) throws Exception {
        try {
            Idprovider.GetIDTokenOnAssumptionRequest.Builder requestBuilder = Idprovider.GetIDTokenOnAssumptionRequest.newBuilder().setSourceNamespace(sourceNamespace).setSourceAppName(sourceAppName).setSourceAppGroup(sourceAppGroup).setSourceAppEnv(sourceAppEnv).setTargetService(factor.getTargetService()).setForceRefresh(forceRefresh);
            EnvConfig envConfig = this.cacheEnvConfig.get();
            if (envConfig != null) {
                requestBuilder.setEnvConfig(Idprovider.EnvConfig.newBuilder().setRegionId(envConfig.getRegionId()).setNamespace(envConfig.getNamespace()).setAppName(envConfig.getAppName()).setAppGroup(envConfig.getAppGroup()).setAppEnv(envConfig.getAppEnv()).setBootstrapToken(envConfig.getBootstrapToken()).setNetworkType(envConfig.getNetworkType()).build());
            }
            Idprovider.TokenResponse response = (Idprovider.TokenResponse)svcAccessorRetryer.call(() -> ((IdpServiceGrpc.IdpServiceBlockingStub)this.blockingServiceStub.withDeadlineAfter(reqConfig.getTimeoutMillis(), TimeUnit.MILLISECONDS)).getIDTokenOnAssumption(requestBuilder.build()));
            return new OIDCToken(response.getPrimaryToken());
        }
        catch (Exception e) {
            Exception normalizedException = ExceptionUtil.normalizeRetryException(e);
            if (normalizedException.getMessage().contains("MismatchParam")) {
                this.cacheEnvConfig.clearEnvConfig();
            }
            logger.error("failed to get idtoken on assumption for application: {}", (Object)normalizedException.getMessage());
            throw normalizedException;
        }
    }

    @Override
    public OIDCToken getIDTokenOnAssumptionForEmp(RequestConfig reqConfig, String empId, TokenFactor factor, boolean forceRefresh) throws Exception {
        try {
            Idprovider.GetIDTokenOnAssumptionForEmpRequest.Builder requestBuilder = Idprovider.GetIDTokenOnAssumptionForEmpRequest.newBuilder().setEmpId(empId).setTargetService(factor.getTargetService()).setForceRefresh(forceRefresh);
            EnvConfig envConfig = this.cacheEnvConfig.get();
            if (envConfig != null) {
                requestBuilder.setEnvConfig(Idprovider.EnvConfig.newBuilder().setRegionId(envConfig.getRegionId()).setNamespace(envConfig.getNamespace()).setAppName(envConfig.getAppName()).setAppGroup(envConfig.getAppGroup()).setAppEnv(envConfig.getAppEnv()).setBootstrapToken(envConfig.getBootstrapToken()).setNetworkType(envConfig.getNetworkType()).build());
            }
            Idprovider.TokenResponse response = (Idprovider.TokenResponse)svcAccessorRetryer.call(() -> ((IdpServiceGrpc.IdpServiceBlockingStub)this.blockingServiceStub.withDeadlineAfter(reqConfig.getTimeoutMillis(), TimeUnit.MILLISECONDS)).getIDTokenOnAssumptionForEmp(requestBuilder.build()));
            return new OIDCToken(response.getPrimaryToken());
        }
        catch (Exception e) {
            Exception normalizedException = ExceptionUtil.normalizeRetryException(e);
            if (normalizedException.getMessage().contains("MismatchParam")) {
                this.cacheEnvConfig.clearEnvConfig();
            }
            logger.error("failed to get idtoken on assumption for employee: {}", (Object)normalizedException.getMessage());
            throw normalizedException;
        }
    }

    @Override
    public CaCerts getCerts(RequestConfig reqConfig, String caller, boolean forceRefresh) throws Exception {
        try {
            Idprovider.GetCertsRequest.Builder requestBuilder = Idprovider.GetCertsRequest.newBuilder().setCaller(caller).setForceRefresh(forceRefresh);
            EnvConfig envConfig = this.cacheEnvConfig.get();
            if (envConfig != null) {
                requestBuilder.setEnvConfig(Idprovider.EnvConfig.newBuilder().setRegionId(envConfig.getRegionId()).setNamespace(envConfig.getNamespace()).setAppName(envConfig.getAppName()).setAppGroup(envConfig.getAppGroup()).setAppEnv(envConfig.getAppEnv()).setBootstrapToken(envConfig.getBootstrapToken()).setNetworkType(envConfig.getNetworkType()).build());
            }
            Idprovider.CertsResponse response = (Idprovider.CertsResponse)svcAccessorRetryer.call(() -> ((IdpServiceGrpc.IdpServiceBlockingStub)this.blockingServiceStub.withDeadlineAfter(reqConfig.getTimeoutMillis(), TimeUnit.MILLISECONDS)).getCerts(requestBuilder.build()));
            return new CaCerts(response.getKeyCertChain().toByteArray(), response.getPrivateKey().toByteArray(), response.getTrustedCerts().toByteArray());
        }
        catch (Exception e) {
            Exception normalizedException = ExceptionUtil.normalizeRetryException(e);
            if (normalizedException.getMessage().contains("MismatchParam")) {
                this.cacheEnvConfig.clearEnvConfig();
            }
            logger.error("failed to get certs: {}", (Object)normalizedException.getMessage());
            throw normalizedException;
        }
    }

    @Override
    public IdpHealthResult checkHealth(boolean reConn) {
        if (this.socketFile == null || !FileUtil.checkSockExisted(this.socketFile)) {
            return new IdpHealthResult(IdpHealthStatus.IDP_UNAVAILABLE, "socket file not found");
        }
        try {
            Idprovider.CheckHealthRequest request;
            Idprovider.CheckHealthResponse response;
            if (reConn) {
                this.channel.checkConnState("idp-server");
            }
            return (response = (Idprovider.CheckHealthResponse)svcAccessorRetryer.call(() -> this.lambda$checkHealth$9(request = Idprovider.CheckHealthRequest.newBuilder().setVersion(idpServerVersion).build()))).getVersionStat() == Idprovider.VersionStat.UP_TO_DATE ? new IdpHealthResult(IdpHealthStatus.IDP_UP_TO_DATE, String.format("idp-server of version %s being up-to-date", response.getGitTag())) : new IdpHealthResult(IdpHealthStatus.IDP_OUT_OF_DATE, String.format("idp-server of version %s being out-of-date compared with sdk version %s", response.getGitTag(), idpServerVersion));
        }
        catch (Exception e) {
            Exception normalizedException = ExceptionUtil.normalizeRetryException(e);
            logger.warn("check health failure: {}", (Object)normalizedException.getMessage());
            if (normalizedException instanceof StatusRuntimeException && ((StatusRuntimeException)normalizedException).getStatus().getCode().equals((Object)Status.Code.UNIMPLEMENTED)) {
                return new IdpHealthResult(IdpHealthStatus.IDP_OUT_OF_DATE, "method not implemented");
            }
            return new IdpHealthResult(IdpHealthStatus.IDP_UNAVAILABLE, normalizedException.getMessage());
        }
    }

    @Override
    public void exitPeer() throws Exception {
        try {
            Idprovider.ExitServerRequest request = Idprovider.ExitServerRequest.newBuilder().setIdentifier("id-provider-sdk").setSourcePid(ProcUtil.getPid()).setSourceLang("java").build();
            svcAccessorRetryer.call(() -> ((ControllerServiceGrpc.ControllerServiceBlockingStub)this.blockingCtrlStub.withDeadlineAfter(Config.GRPC_SVC_ACCESS_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS)).exitServer(request));
            channelStateChecker.call(() -> this.channel.channel.getState(false));
        }
        catch (StatusRuntimeException e) {
            if (!e.getStatus().getCode().equals((Object)Status.Code.UNIMPLEMENTED)) {
                throw e;
            }
            IdproviderV0.ExitServerRequest request = IdproviderV0.ExitServerRequest.newBuilder().setIdentifier("id-provider-sdk").setSourcePid(ProcUtil.getPid()).build();
            ((ControllerServiceGrpc.ControllerServiceBlockingStub)this.blockingCtrlStubV0.withDeadlineAfter(Config.GRPC_SVC_ACCESS_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS)).exitServer(request);
            channelStateChecker.call(() -> this.channel.channel.getState(false));
        }
        catch (Exception e) {
            Exception normalizedException = ExceptionUtil.normalizeRetryException(e);
            logger.error("failed to exit peer: {}", (Object)normalizedException.getMessage());
            throw normalizedException;
        }
    }

    @Override
    public void shutdown() {
        if (this.channel != null) {
            this.channel.shutdown();
        }
    }

    public static File getSockFile() throws IdpException {
        String sockPath = Paths.get(FileUtil.getAndMakeBinDir(), defaultSockName).toString();
        File socketFile = new File(sockPath);
        if (!FileUtil.checkSockExisted(socketFile)) {
            throw new IdpException(IdpErrorCode.GRPC_SERVICE_NOT_READY, "idp-server", String.format("no available unix socket found on %s", sockPath));
        }
        return socketFile;
    }

    public static boolean checkSockFile() {
        try {
            IdpAccessor.getSockFile();
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private boolean isStagingToken() {
        return "staging".equals(System.getenv("AKLESS_IDP_ACCESS_LEVEL"));
    }

    private /* synthetic */ Object lambda$checkHealth$9(Idprovider.CheckHealthRequest request) throws Exception {
        return ((ControllerServiceGrpc.ControllerServiceBlockingStub)this.blockingCtrlStub.withDeadlineAfter(Config.GRPC_SVC_ACCESS_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS)).checkHealth(request);
    }

    private class CacheToken {
        private ConcurrentMap<TokenFactor, RawOIDCToken> rawTokenMap = new ConcurrentHashMap<TokenFactor, RawOIDCToken>();

        private CacheToken() {
        }

        public OIDCToken get(TokenFactor factor) {
            RawOIDCToken rawToken = (RawOIDCToken)this.rawTokenMap.get(factor);
            if (rawToken == null) {
                return null;
            }
            if (rawToken.primaryTokenExpiration >= new Date().getTime() || rawToken.getBackupToken().isEmpty()) {
                return new OIDCToken(rawToken.getPrimaryToken());
            }
            logger.info("turn to use backup token while it's close to the expiration of primary token");
            return new OIDCToken(rawToken.getBackupToken());
        }

        public void update(TokenFactor factor, Idprovider.TokenResponse resp) {
            if (factor == null || resp == null) {
                return;
            }
            this.rawTokenMap.put(factor, new RawOIDCToken(resp.getPrimaryToken(), resp.getBackupToken()));
        }
    }

    private class RawOIDCToken {
        String primaryToken;
        String backupToken;
        long primaryTokenExpiration;

        public RawOIDCToken(String primaryToken, String backupToken) {
            this.primaryToken = primaryToken;
            this.backupToken = backupToken;
            try {
                this.primaryTokenExpiration = JwtUtil.getTokenExpirationDate(primaryToken).getTime() - (IdpAccessor.this.isStagingToken() ? 60000L : Config.TOKEN_EXPIRE_GAP_MILLIS);
            }
            catch (Exception ignored) {
                this.primaryTokenExpiration = 0L;
            }
        }

        public String getPrimaryToken() {
            return this.primaryToken;
        }

        public String getBackupToken() {
            return this.backupToken;
        }

        public long getPrimaryTokenExpiration() {
            return this.primaryTokenExpiration;
        }

        public void setPrimaryToken(String primaryToken) {
            this.primaryToken = primaryToken;
        }

        public void setBackupToken(String backupToken) {
            this.backupToken = backupToken;
        }

        public void setPrimaryTokenExpiration(long primaryTokenExpiration) {
            this.primaryTokenExpiration = primaryTokenExpiration;
        }
    }

    private class CacheEnvConfig {
        private EnvConfig envConfig = null;
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

        private CacheEnvConfig() {
        }

        public EnvConfig get() {
            try {
                this.lock.readLock().lock();
                EnvConfig envConfig = this.envConfig;
                return envConfig;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void update(EnvConfig envConfig) {
            if (envConfig == null) {
                return;
            }
            try {
                this.lock.writeLock().lock();
                this.envConfig = envConfig;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public void clearEnvConfig() {
            try {
                this.lock.writeLock().lock();
                this.envConfig = null;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }
}

