/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.accessor;

import com.aliyun.akless.idprovider.utils.ProcUtil;
import com.aliyun.akless.idprovider.utils.config.Config;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialCache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(CredentialCache.class);
    private final BiFunction<K, Long, V> credentialRefresher;
    private Map<K, V> credentialCaches = new ConcurrentHashMap();
    private static AtomicLong refreshCounter = new AtomicLong(0L);
    private static final long defaultRefreshIntervalMilliSeconds = 60000L;

    public CredentialCache(final String source, final BiFunction<K, Long, V> credentialRefresher, long refreshInterval, final long refreshTimeoutMs) {
        this.credentialRefresher = credentialRefresher;
        Timer refreshScheduler = new Timer(String.format("akless-idp-cache-refresher-%s", source), true);
        refreshScheduler.schedule(new TimerTask(){

            @Override
            public void run() {
                for (Object cacheKey : CredentialCache.this.credentialCaches.keySet()) {
                    try {
                        CredentialCache.this.credentialCaches.put(cacheKey, credentialRefresher.apply(cacheKey, refreshTimeoutMs));
                        refreshCounter.incrementAndGet();
                        logger.debug("[pid - {}] success on scheduled {} refresh for {}", new Object[]{ProcUtil.getPid(), source, cacheKey.toString()});
                    }
                    catch (Exception e) {
                        logger.warn("[pid - {}] failed on scheduled {} refresh for {}: {}", new Object[]{ProcUtil.getPid(), source, cacheKey.toString(), e.getMessage()});
                    }
                }
            }
        }, refreshInterval, refreshInterval);
    }

    public CredentialCache(String source, BiFunction<K, Long, V> credentialRefresher, long refreshInterval) {
        this(source, credentialRefresher, refreshInterval, Config.GRPC_SVC_ACCESS_TIMEOUT_MILLIS);
    }

    public CredentialCache(String source, BiFunction<K, Long, V> credentialRefresher) {
        this(source, credentialRefresher, 60000L);
    }

    public V get(K factor) throws Exception {
        return this.get(factor, Config.GRPC_SVC_ACCESS_TIMEOUT_MILLIS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K factor, long timeoutMillis) throws Exception {
        V credential = this.credentialCaches.get(factor);
        if (credential != null) {
            return credential;
        }
        CredentialCache credentialCache = this;
        synchronized (credentialCache) {
            credential = this.credentialCaches.get(factor);
            if (credential != null) {
                return credential;
            }
            credential = this.credentialRefresher.apply(factor, timeoutMillis);
            this.credentialCaches.put(factor, credential);
        }
        return credential;
    }

    public void put(K factor, V credential) {
        this.credentialCaches.put(factor, credential);
    }

    public long stat() {
        return refreshCounter.get();
    }
}

