/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.accessor;

import com.aliyun.akless.idprovider.accessor.CredentialCache;
import com.aliyun.akless.idprovider.accessor.IAccessor;
import com.aliyun.akless.idprovider.accessor.IdpAccessor;
import com.aliyun.akless.idprovider.accessor.SecretAccessor;
import com.aliyun.akless.idprovider.accessor.config.RequestConfig;
import com.aliyun.akless.idprovider.enums.IdpHealthResult;
import com.aliyun.akless.idprovider.enums.TokenCredType;
import com.aliyun.akless.idprovider.errors.IdpErrorCode;
import com.aliyun.akless.idprovider.errors.IdpException;
import com.aliyun.akless.idprovider.model.CaCerts;
import com.aliyun.akless.idprovider.model.EnvConfig;
import com.aliyun.akless.idprovider.model.OIDCToken;
import com.aliyun.akless.idprovider.model.TokenFactor;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.RetryException;
import com.aliyun.akless.idprovider.shaded.io.grpc.StatusRuntimeException;
import com.aliyun.akless.idprovider.utils.ExceptionUtil;
import com.aliyun.akless.idprovider.utils.config.Config;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessorProxy {
    private static final Logger logger = LoggerFactory.getLogger(AccessorProxy.class);
    private static volatile AccessorProxy defaultAccessorProxy = null;
    private final IAccessor internalAccessor;
    private final CredentialCache<TokenFactor, OIDCToken> tokenCache;
    private final CredentialCache<String, CaCerts> certCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AccessorProxy getAccessor() throws IdpException {
        if (!AccessorProxy.initRequired()) return defaultAccessorProxy;
        Class<AccessorProxy> clazz = AccessorProxy.class;
        synchronized (AccessorProxy.class) {
            if (!AccessorProxy.initRequired()) return defaultAccessorProxy;
            defaultAccessorProxy = new AccessorProxy();
            logger.debug("succeed to create a new accessor proxy");
            Runtime.getRuntime().addShutdownHook(new Thread(() -> defaultAccessorProxy.shutdown()));
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultAccessorProxy;
        }
    }

    private AccessorProxy() {
        try {
            this.internalAccessor = AccessorProxy.inPod() ? new SecretAccessor() : new IdpAccessor();
            this.tokenCache = new CredentialCache<TokenFactor, OIDCToken>("idtoken", (tokenFactor, timeoutMs) -> {
                try {
                    return this.internalAccessor.getIDToken(new RequestConfig((long)timeoutMs), (TokenFactor)tokenFactor);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            this.certCache = new CredentialCache<String, CaCerts>("cert", (caller, timeoutMs) -> {
                try {
                    return this.internalAccessor.getCerts(new RequestConfig((long)timeoutMs), (String)caller, false);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            throw AccessorProxy.buildException(e, IdpErrorCode.CREATE_GRPC_ACCESSOR_FAILED, e.getMessage());
        }
    }

    private static boolean initRequired() {
        return defaultAccessorProxy == null;
    }

    public static boolean inPod() {
        return SecretAccessor.checkSockFile();
    }

    public EnvConfig initEnvConfig(String regionId, String namespace, String appName, String appGroup, String appEnv, String bootstrapToken) throws IdpException {
        return this.initEnvConfig(regionId, namespace, appName, appGroup, appEnv, bootstrapToken, Config.INIT_ENV_TIMEOUT_MILLIS);
    }

    public EnvConfig initEnvConfig(String regionId, String namespace, String appName, String appGroup, String appEnv, String bootstrapToken, long timeoutMillis) throws IdpException {
        try {
            return this.internalAccessor.initEnvConfig(new RequestConfig(timeoutMillis), regionId, namespace, appName, appGroup, appEnv, bootstrapToken);
        }
        catch (Exception e) {
            throw AccessorProxy.buildException(e, IdpErrorCode.INIT_ENV_CONFIG_FAILED, e.getMessage());
        }
    }

    public OIDCToken getIDToken(TokenFactor factor) throws IdpException {
        return this.getIDToken(factor, Config.GRPC_SVC_ACCESS_TIMEOUT_MILLIS);
    }

    public OIDCToken getIDToken(TokenFactor factor, long timeoutMillis) throws IdpException {
        try {
            return this.tokenCache.get(factor, timeoutMillis);
        }
        catch (Exception e) {
            throw AccessorProxy.buildException(e, IdpErrorCode.RETRIEVE_TOKEN_FAILED, new Object[]{factor.getSignAlg(), factor.getTargetService(), e.getMessage()});
        }
    }

    public OIDCToken refreshIDToken(TokenFactor factor) throws IdpException {
        return this.refreshIDToken(factor, Config.GRPC_SVC_ACCESS_TIMEOUT_MILLIS);
    }

    public OIDCToken refreshIDToken(TokenFactor factor, long timeoutMillis) throws IdpException {
        try {
            logger.info("start to refresh idtoken against signing algorithm {} and target service {}", (Object)factor.getSignAlg(), (Object)factor.getTargetService());
            OIDCToken oidcToken = this.internalAccessor.refreshIDToken(new RequestConfig(timeoutMillis), factor);
            this.tokenCache.put(factor, oidcToken);
            return oidcToken;
        }
        catch (Exception e) {
            throw AccessorProxy.buildException(e, IdpErrorCode.REFRESH_TOKEN_FAILED, new Object[]{factor.getSignAlg(), factor.getTargetService(), e.getMessage()});
        }
    }

    public OIDCToken getIDTokenOnBehalf(TokenCredType sourceCredentialType, String sourceCredential, TokenFactor factor, boolean forceRefresh) throws IdpException {
        return this.getIDTokenOnBehalf(sourceCredentialType, sourceCredential, factor, forceRefresh, Config.GRPC_SVC_ACCESS_TIMEOUT_MILLIS);
    }

    public OIDCToken getIDTokenOnBehalf(TokenCredType sourceCredentialType, String sourceCredential, TokenFactor factor, boolean forceRefresh, long timeoutMillis) throws IdpException {
        try {
            logger.info("start to get idtoken on behalf against credential type {} and target service {}", (Object)sourceCredentialType.getType(), (Object)factor.getTargetService());
            return this.internalAccessor.getIDTokenOnBehalf(new RequestConfig(timeoutMillis), sourceCredentialType, sourceCredential, factor, forceRefresh);
        }
        catch (Exception e) {
            throw AccessorProxy.buildException(e, IdpErrorCode.GET_TOKEN_ON_BEHALF_FAILED, factor.getTargetService(), e.getMessage());
        }
    }

    public OIDCToken getIDTokenOnAssumptionForApp(String sourceNamespace, String sourceAppName, String sourceAppGroup, String sourceAppEnv, TokenFactor factor, boolean forceRefresh) throws IdpException {
        return this.getIDTokenOnAssumptionForApp(sourceNamespace, sourceAppName, sourceAppGroup, sourceAppEnv, factor, forceRefresh, Config.GRPC_SVC_ACCESS_TIMEOUT_MILLIS);
    }

    public OIDCToken getIDTokenOnAssumptionForApp(String sourceNamespace, String sourceAppName, String sourceAppGroup, String sourceAppEnv, TokenFactor factor, boolean forceRefresh, long timeoutMillis) throws IdpException {
        try {
            logger.info("start to get idtoken on assumption for application against source namespace {}, source app name {}, source app group {}, source app env {} and target service {}", new Object[]{sourceNamespace, sourceAppName, sourceAppGroup, sourceAppEnv, factor.getTargetService()});
            return this.internalAccessor.getIDTokenOnAssumptionForApp(new RequestConfig(timeoutMillis), sourceNamespace, sourceAppName, sourceAppGroup, sourceAppEnv, factor, forceRefresh);
        }
        catch (Exception e) {
            throw AccessorProxy.buildException(e, IdpErrorCode.GET_TOKEN_ON_ASSUMPTION_FOR_APP_FAILED, sourceNamespace, sourceAppName, sourceAppGroup, sourceAppEnv, factor.getTargetService(), e.getMessage());
        }
    }

    public OIDCToken getIDTokenOnAssumptionForEmp(String empId, TokenFactor factor, boolean forceRefresh) throws IdpException {
        return this.getIDTokenOnAssumptionForEmp(empId, factor, forceRefresh, Config.GRPC_SVC_ACCESS_TIMEOUT_MILLIS);
    }

    public OIDCToken getIDTokenOnAssumptionForEmp(String empId, TokenFactor factor, boolean forceRefresh, long timeoutMillis) throws IdpException {
        try {
            logger.info("start to get idtoken on assumption for employee against employee id {} and target service {}", (Object)empId, (Object)factor.getTargetService());
            return this.internalAccessor.getIDTokenOnAssumptionForEmp(new RequestConfig(timeoutMillis), empId, factor, forceRefresh);
        }
        catch (Exception e) {
            throw AccessorProxy.buildException(e, IdpErrorCode.GET_TOKEN_ON_ASSUMPTION_FOR_EMP_FAILED, empId, factor.getTargetService(), e.getMessage());
        }
    }

    public IdpHealthResult checkHealth(boolean reConn) {
        return this.internalAccessor.checkHealth(reConn);
    }

    public void exitPeer() {
        try {
            this.internalAccessor.exitPeer();
        }
        catch (Exception e) {
            throw AccessorProxy.buildException(e, IdpErrorCode.EXIT_PEER_SERVER_FAILED, e.getMessage());
        }
    }

    public void shutdown() {
        this.internalAccessor.shutdown();
    }

    public CaCerts getCerts(String caller) throws IdpException {
        return this.getCerts(caller, Config.GRPC_CERTS_ACCESS_TIMEOUT_MILLIS);
    }

    public CaCerts getCerts(String caller, long timeoutMillis) throws IdpException {
        try {
            return this.certCache.get(caller, timeoutMillis);
        }
        catch (Exception e) {
            throw AccessorProxy.buildException(e, IdpErrorCode.RETRIEVE_CACERTS_FAILED, e.getMessage());
        }
    }

    public CaCerts refreshCerts(String caller) throws IdpException {
        return this.refreshCerts(caller, 5000L);
    }

    public CaCerts refreshCerts(String caller, long timeoutMillis) throws IdpException {
        try {
            logger.info("start to refresh ca certs");
            CaCerts certs = this.internalAccessor.getCerts(new RequestConfig(timeoutMillis), caller, true);
            this.certCache.put(caller, certs);
            return certs;
        }
        catch (Exception e) {
            throw AccessorProxy.buildException(e, IdpErrorCode.REFRESH_CACERTS_FAILED, e.getMessage());
        }
    }

    private static IdpException buildException(Exception e, IdpErrorCode code, Object ... args) {
        if (e instanceof IdpException) {
            return (IdpException)e;
        }
        if (e instanceof StatusRuntimeException || e instanceof ExecutionException) {
            return new IdpException(code, args);
        }
        if (e instanceof RetryException) {
            return new IdpException(IdpErrorCode.GRPC_SERVICE_UNRESPONSIVE, ExceptionUtil.normalizeRetryException(e).getMessage());
        }
        return new IdpException(code, args);
    }
}

