/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.propertydescriptor;

import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.factory.DestBeanCreator;
import com.github.dozermapper.core.fieldmap.HintContainer;
import com.github.dozermapper.core.propertydescriptor.CustomGetSetPropertyDescriptor;
import com.github.dozermapper.core.propertydescriptor.DozerPropertyDescriptor;
import com.github.dozermapper.core.propertydescriptor.FieldPropertyDescriptor;
import com.github.dozermapper.core.propertydescriptor.JavaBeanPropertyDescriptor;
import com.github.dozermapper.core.propertydescriptor.MapPropertyDescriptor;
import com.github.dozermapper.core.propertydescriptor.PropertyDescriptorCreationStrategy;
import com.github.dozermapper.core.propertydescriptor.SelfPropertyDescriptor;
import com.github.dozermapper.core.propertydescriptor.XmlBeanPropertyDescriptor;
import com.github.dozermapper.core.util.DozerConstants;
import com.github.dozermapper.core.util.MappingUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;

public final class PropertyDescriptorFactory {
    private final List<PropertyDescriptorCreationStrategy> pluggedDescriptorCreationStrategies = new ArrayList<PropertyDescriptorCreationStrategy>();

    public DozerPropertyDescriptor getPropertyDescriptor(Class<?> clazz, String theGetMethod, String theSetMethod, String mapGetMethod, String mapSetMethod, boolean isAccessible, boolean isIndexed, int index, String name, String key, boolean isSelfReferencing, String oppositeFieldName, HintContainer srcDeepIndexHintContainer, HintContainer destDeepIndexHintContainer, String beanFactory, BeanContainer beanContainer, DestBeanCreator destBeanCreator) {
        DozerPropertyDescriptor desc = null;
        boolean isMapProperty = MappingUtils.isSupportedMap(clazz);
        if (name.equals("this") && (mapSetMethod != null || mapGetMethod != null || isMapProperty)) {
            String setMethod = StringUtils.isBlank((CharSequence)mapSetMethod) ? "put" : mapSetMethod;
            String getMethod = StringUtils.isBlank((CharSequence)mapGetMethod) ? "get" : mapGetMethod;
            desc = new MapPropertyDescriptor(clazz, name, isIndexed, index, setMethod, getMethod, key != null ? key : oppositeFieldName, srcDeepIndexHintContainer, destDeepIndexHintContainer, beanContainer, destBeanCreator);
        } else if (isSelfReferencing) {
            desc = new SelfPropertyDescriptor(clazz);
        } else if (isAccessible) {
            desc = new FieldPropertyDescriptor(clazz, name, isIndexed, index, srcDeepIndexHintContainer, destDeepIndexHintContainer, destBeanCreator);
        } else if (theSetMethod != null || theGetMethod != null) {
            desc = new CustomGetSetPropertyDescriptor(clazz, name, isIndexed, index, theSetMethod, theGetMethod, srcDeepIndexHintContainer, destDeepIndexHintContainer, beanContainer, destBeanCreator);
        } else if (beanFactory != null && beanFactory.equals(DozerConstants.XML_BEAN_FACTORY)) {
            desc = new XmlBeanPropertyDescriptor(clazz, name, isIndexed, index, srcDeepIndexHintContainer, destDeepIndexHintContainer, beanContainer, destBeanCreator);
        }
        if (desc != null) {
            return desc;
        }
        for (PropertyDescriptorCreationStrategy propertyDescriptorBuilder : new CopyOnWriteArrayList<PropertyDescriptorCreationStrategy>(this.pluggedDescriptorCreationStrategies)) {
            if (propertyDescriptorBuilder.isApplicable(clazz, name) && (desc = propertyDescriptorBuilder.buildFor(clazz, name, isIndexed, index, srcDeepIndexHintContainer, destDeepIndexHintContainer)) != null) break;
        }
        if (desc == null) {
            desc = new JavaBeanPropertyDescriptor(clazz, name, isIndexed, index, srcDeepIndexHintContainer, destDeepIndexHintContainer, beanContainer, destBeanCreator);
        }
        return desc;
    }

    public void addPluggedPropertyDescriptorCreationStrategies(Collection<PropertyDescriptorCreationStrategy> strategies) {
        this.pluggedDescriptorCreationStrategies.addAll(strategies);
    }
}

