/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.utils.sampler;

import com.alibaba.securitysdk.logging.utils.AssertUtil;
import com.alibaba.securitysdk.logging.utils.Throwables;
import com.alibaba.securitysdk.logging.utils.sampler.RatioSampler;
import com.alibaba.securitysdk.logging.utils.sampler.Sampler;

public class StackSampler
implements Sampler<String> {
    private final Sampler<Boolean> booleanSampler;
    private final int stackTopDepth;
    private final int stackBottomDepth;

    public StackSampler(long ratio, int stackTopDepth, int stackBottomDepth) {
        this(stackTopDepth, stackBottomDepth, (Sampler<Boolean>)new RatioSampler(ratio));
    }

    public StackSampler(long ratio, int stackTopDepth, Sampler<Boolean> booleanSampler) {
        this(stackTopDepth, stackTopDepth, booleanSampler);
    }

    public StackSampler(int stackTopDepth, int stackBottomDepth, Sampler<Boolean> booleanSampler) {
        AssertUtil.checkArgument(stackTopDepth >= 10);
        AssertUtil.checkArgument(stackBottomDepth >= 0);
        this.booleanSampler = AssertUtil.notNull(booleanSampler);
        this.stackTopDepth = stackTopDepth;
        this.stackBottomDepth = stackBottomDepth;
    }

    @Override
    public String sample() {
        if (this.booleanSampler.sample().booleanValue()) {
            return Throwables.currentStackTraceAsString(this.stackTopDepth, this.stackBottomDepth);
        }
        return null;
    }
}

