/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.utils.sampler;

import com.alibaba.securitysdk.logging.utils.AssertUtil;
import com.alibaba.securitysdk.logging.utils.sampler.Sampler;
import java.util.concurrent.atomic.AtomicInteger;

public class RatioSampler
implements Sampler<Boolean> {
    private final AtomicInteger ai = new AtomicInteger();
    private final long ratio;
    private static final long DEFAULT_RATIO = 100L;

    public RatioSampler() {
        this(100L);
    }

    public RatioSampler(long ratio) {
        AssertUtil.checkArgument(ratio > 0L);
        this.ratio = ratio;
    }

    @Override
    public Boolean sample() {
        return (long)this.ai.getAndIncrement() % this.ratio == 0L;
    }

    public long getRatio() {
        return this.ratio;
    }
}

