/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.hue.convert;

import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvert;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvertFactory;
import com.aliyun.migration.workflow.migration.common.type.HueNodeType;
import com.workflow.migration.transform.dw.hue.convert.ForkConvert;
import com.workflow.migration.transform.dw.hue.convert.HiveConvert;
import com.workflow.migration.transform.dw.hue.convert.JoinConvert;
import com.workflow.migration.transform.dw.hue.convert.ShellConvert;
import com.workflow.migration.transform.dw.hue.convert.SqoopConvert;
import com.workflow.migration.transform.dw.hue.convert.VirtualityConvert;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HueConvertFactory
extends AbstractConvertFactory {
    private static final Logger log = LoggerFactory.getLogger(HueConvertFactory.class);

    public AbstractConvert<List<WorkflowNode>> getNodeListConvert(String taskTypeStr, TaskContext taskContext, Workflow workflow) {
        HueNodeType taskType = this.getTaskType(taskTypeStr);
        if (taskType == null) {
            log.warn("not supported thie tasktype {}, use default convert", (Object)taskTypeStr);
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.NODE_TYPE_NOT_FOUND);
        }
        return switch (taskType) {
            default -> throw new IncompatibleClassChangeError();
            case HueNodeType.FORK -> new ForkConvert(taskContext, workflow);
            case HueNodeType.JOIN -> new JoinConvert(taskContext, workflow);
            case HueNodeType.OK, HueNodeType.ERROR -> new VirtualityConvert(taskContext, workflow);
            case HueNodeType.SQOOP -> new SqoopConvert(taskContext, workflow);
            case HueNodeType.HIVE, HueNodeType.HIVE2 -> new HiveConvert(taskContext, workflow);
            case HueNodeType.SHELL -> new ShellConvert(taskContext, workflow);
        };
    }

    private HueNodeType getTaskType(String taskTypeStr) {
        try {
            return HueNodeType.valueOf((String)taskTypeStr);
        }
        catch (Exception e) {
            log.error("get taskType error");
            return null;
        }
    }
}

