/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.org.apache.xerces.util;

import com.alibaba.securitysdk.org.apache.xerces.xni.XMLResourceIdentifier;
import com.alibaba.securitysdk.org.apache.xerces.xni.XNIException;
import com.alibaba.securitysdk.org.apache.xerces.xni.parser.XMLEntityResolver;
import com.alibaba.securitysdk.org.apache.xerces.xni.parser.XMLInputSource;
import com.alibaba.securitysdk.org.xml.sax.EntityResolver;
import com.alibaba.securitysdk.org.xml.sax.InputSource;
import com.alibaba.securitysdk.org.xml.sax.SAXException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class EntityResolverWrapper
implements XMLEntityResolver {
    protected EntityResolver fEntityResolver;

    public EntityResolverWrapper() {
    }

    public EntityResolverWrapper(EntityResolver entityResolver) {
        this.setEntityResolver(entityResolver);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.fEntityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.fEntityResolver;
    }

    @Override
    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
        String pubId = resourceIdentifier.getPublicId();
        String sysId = resourceIdentifier.getExpandedSystemId();
        if (pubId == null && sysId == null) {
            return null;
        }
        if (this.fEntityResolver != null && resourceIdentifier != null) {
            try {
                InputSource inputSource = this.fEntityResolver.resolveEntity(pubId, sysId);
                if (inputSource != null) {
                    String publicId = inputSource.getPublicId();
                    String systemId = inputSource.getSystemId();
                    String baseSystemId = resourceIdentifier.getBaseSystemId();
                    InputStream byteStream = inputSource.getByteStream();
                    Reader charStream = inputSource.getCharacterStream();
                    String encoding = inputSource.getEncoding();
                    XMLInputSource xmlInputSource = new XMLInputSource(publicId, systemId, baseSystemId);
                    xmlInputSource.setByteStream(byteStream);
                    xmlInputSource.setCharacterStream(charStream);
                    xmlInputSource.setEncoding(encoding);
                    return xmlInputSource;
                }
            }
            catch (SAXException e) {
                Throwable ex = e.getException();
                if (ex == null) {
                    ex = e;
                }
                throw new XNIException((Exception)ex);
            }
        }
        return null;
    }
}

