/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.org.apache.xerces.impl.xs.util;

import com.alibaba.securitysdk.org.apache.xerces.xs.ShortList;
import com.alibaba.securitysdk.org.apache.xerces.xs.XSException;

public class ShortListImpl
implements ShortList {
    public static final ShortList EMPTY_LIST = new ShortList(){

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public boolean contains(short item) {
            return false;
        }

        @Override
        public short item(int index) throws XSException {
            throw new XSException(2, null);
        }
    };
    private short[] fArray = null;
    private int fLength = 0;

    public ShortListImpl(short[] array, int length) {
        this.fArray = array;
        this.fLength = length;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public boolean contains(short item) {
        for (int i = 0; i < this.fLength; ++i) {
            if (this.fArray[i] != item) continue;
            return true;
        }
        return false;
    }

    @Override
    public short item(int index) throws XSException {
        if (index < 0 || index >= this.fLength) {
            throw new XSException(2, null);
        }
        return this.fArray[index];
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ShortList)) {
            return false;
        }
        ShortList rhs = (ShortList)obj;
        if (this.fLength != rhs.getLength()) {
            return false;
        }
        for (int i = 0; i < this.fLength; ++i) {
            if (this.fArray[i] == rhs.item(i)) continue;
            return false;
        }
        return true;
    }
}

