/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.org.apache.xerces.impl.xs.models;

import com.alibaba.securitysdk.org.apache.xerces.impl.dtd.models.CMNode;
import com.alibaba.securitysdk.org.apache.xerces.impl.dtd.models.CMStateSet;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.XMLSchemaException;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.XSConstraints;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.XSElementDecl;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.XSWildcardDecl;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.models.XSCMBinOp;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.models.XSCMLeaf;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.models.XSCMUniOp;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.models.XSCMValidator;
import com.alibaba.securitysdk.org.apache.xerces.xni.QName;
import java.util.HashMap;
import java.util.Vector;

public class XSDFACM
implements XSCMValidator {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_VALIDATE_CONTENT = false;
    private Object[] fElemMap = null;
    private int[] fElemMapType = null;
    private int[] fElemMapId = null;
    private int fElemMapSize = 0;
    private boolean[] fFinalStateFlags = null;
    private CMStateSet[] fFollowList = null;
    private CMNode fHeadNode = null;
    private int fLeafCount = 0;
    private XSCMLeaf[] fLeafList = null;
    private int[] fLeafListType = null;
    private int[][] fTransTable = null;
    private int fTransTableSize = 0;
    private static long time = 0L;

    public XSDFACM(CMNode syntaxTree, int leafCount) {
        this.fLeafCount = leafCount;
        this.buildDFA(syntaxTree);
    }

    public boolean isFinalState(int state) {
        return state < 0 ? false : this.fFinalStateFlags[state];
    }

    @Override
    public Object oneTransition(QName curElem, int[] state, SubstitutionGroupHandler subGroupHandler) {
        int elemIndex;
        int curState = state[0];
        if (curState == -1 || curState == -2) {
            if (curState == -1) {
                state[0] = -2;
            }
            return this.findMatchingDecl(curElem, subGroupHandler);
        }
        int nextState = 0;
        Object matchingDecl = null;
        for (elemIndex = 0; elemIndex < this.fElemMapSize; ++elemIndex) {
            nextState = this.fTransTable[curState][elemIndex];
            if (nextState == -1) continue;
            int type = this.fElemMapType[elemIndex];
            if (type == 1) {
                matchingDecl = subGroupHandler.getMatchingElemDecl(curElem, (XSElementDecl)this.fElemMap[elemIndex]);
                if (matchingDecl == null) continue;
                break;
            }
            if (type != 2 || !((XSWildcardDecl)this.fElemMap[elemIndex]).allowNamespace(curElem.uri)) continue;
            matchingDecl = this.fElemMap[elemIndex];
            break;
        }
        if (elemIndex == this.fElemMapSize) {
            state[1] = state[0];
            state[0] = -1;
            return this.findMatchingDecl(curElem, subGroupHandler);
        }
        state[0] = nextState;
        return matchingDecl;
    }

    Object findMatchingDecl(QName curElem, SubstitutionGroupHandler subGroupHandler) {
        XSElementDecl matchingDecl = null;
        for (int elemIndex = 0; elemIndex < this.fElemMapSize; ++elemIndex) {
            int type = this.fElemMapType[elemIndex];
            if (type == 1) {
                matchingDecl = subGroupHandler.getMatchingElemDecl(curElem, (XSElementDecl)this.fElemMap[elemIndex]);
                if (matchingDecl == null) continue;
                return matchingDecl;
            }
            if (type != 2 || !((XSWildcardDecl)this.fElemMap[elemIndex]).allowNamespace(curElem.uri)) continue;
            return this.fElemMap[elemIndex];
        }
        return null;
    }

    @Override
    public int[] startContentModel() {
        int[] val = new int[2];
        val[0] = 0;
        return val;
    }

    @Override
    public boolean endContentModel(int[] state) {
        return this.fFinalStateFlags[state[0]];
    }

    private void buildDFA(CMNode syntaxTree) {
        int EOCPos = this.fLeafCount;
        XSCMLeaf nodeEOC = new XSCMLeaf(1, null, -1, this.fLeafCount++);
        this.fHeadNode = new XSCMBinOp(102, syntaxTree, nodeEOC);
        this.fLeafList = new XSCMLeaf[this.fLeafCount];
        this.fLeafListType = new int[this.fLeafCount];
        this.postTreeBuildInit(this.fHeadNode);
        this.fFollowList = new CMStateSet[this.fLeafCount];
        for (int index = 0; index < this.fLeafCount; ++index) {
            this.fFollowList[index] = new CMStateSet(this.fLeafCount);
        }
        this.calcFollowList(this.fHeadNode);
        this.fElemMap = new Object[this.fLeafCount];
        this.fElemMapType = new int[this.fLeafCount];
        this.fElemMapId = new int[this.fLeafCount];
        this.fElemMapSize = 0;
        for (int outIndex = 0; outIndex < this.fLeafCount; ++outIndex) {
            int inIndex;
            this.fElemMap[outIndex] = null;
            int id = this.fLeafList[outIndex].getParticleId();
            for (inIndex = 0; inIndex < this.fElemMapSize && id != this.fElemMapId[inIndex]; ++inIndex) {
            }
            if (inIndex != this.fElemMapSize) continue;
            this.fElemMap[this.fElemMapSize] = this.fLeafList[outIndex].getLeaf();
            this.fElemMapType[this.fElemMapSize] = this.fLeafListType[outIndex];
            this.fElemMapId[this.fElemMapSize] = id;
            ++this.fElemMapSize;
        }
        --this.fElemMapSize;
        int[] fLeafSorter = new int[this.fLeafCount + this.fElemMapSize];
        int fSortCount = 0;
        for (int elemIndex = 0; elemIndex < this.fElemMapSize; ++elemIndex) {
            int id = this.fElemMapId[elemIndex];
            for (int leafIndex = 0; leafIndex < this.fLeafCount; ++leafIndex) {
                if (id != this.fLeafList[leafIndex].getParticleId()) continue;
                fLeafSorter[fSortCount++] = leafIndex;
            }
            fLeafSorter[fSortCount++] = -1;
        }
        int curArraySize = this.fLeafCount * 4;
        CMStateSet[] statesToDo = new CMStateSet[curArraySize];
        this.fFinalStateFlags = new boolean[curArraySize];
        this.fTransTable = new int[curArraySize][];
        CMStateSet setT = this.fHeadNode.firstPos();
        int unmarkedState = 0;
        int curState = 0;
        this.fTransTable[curState] = this.makeDefStateList();
        statesToDo[curState] = setT;
        ++curState;
        HashMap<CMStateSet, Integer> stateTable = new HashMap<CMStateSet, Integer>();
        while (unmarkedState < curState) {
            setT = statesToDo[unmarkedState];
            int[] transEntry = this.fTransTable[unmarkedState];
            this.fFinalStateFlags[unmarkedState] = setT.getBit(EOCPos);
            ++unmarkedState;
            CMStateSet newSet = null;
            int sorterIndex = 0;
            for (int elemIndex = 0; elemIndex < this.fElemMapSize; ++elemIndex) {
                int stateIndex;
                if (newSet == null) {
                    newSet = new CMStateSet(this.fLeafCount);
                } else {
                    newSet.zeroBits();
                }
                int leafIndex = fLeafSorter[sorterIndex++];
                while (leafIndex != -1) {
                    if (setT.getBit(leafIndex)) {
                        newSet.union(this.fFollowList[leafIndex]);
                    }
                    leafIndex = fLeafSorter[sorterIndex++];
                }
                if (newSet.isEmpty()) continue;
                Integer stateObj = (Integer)stateTable.get(newSet);
                int n = stateIndex = stateObj == null ? curState : stateObj;
                if (stateIndex == curState) {
                    statesToDo[curState] = newSet;
                    this.fTransTable[curState] = this.makeDefStateList();
                    stateTable.put(newSet, new Integer(curState));
                    ++curState;
                    newSet = null;
                }
                transEntry[elemIndex] = stateIndex;
                if (curState != curArraySize) continue;
                int newSize = (int)((double)curArraySize * 1.5);
                CMStateSet[] newToDo = new CMStateSet[newSize];
                boolean[] newFinalFlags = new boolean[newSize];
                int[][] newTransTable = new int[newSize][];
                System.arraycopy(statesToDo, 0, newToDo, 0, curArraySize);
                System.arraycopy(this.fFinalStateFlags, 0, newFinalFlags, 0, curArraySize);
                System.arraycopy(this.fTransTable, 0, newTransTable, 0, curArraySize);
                curArraySize = newSize;
                statesToDo = newToDo;
                this.fFinalStateFlags = newFinalFlags;
                this.fTransTable = newTransTable;
            }
        }
        this.fHeadNode = null;
        this.fLeafList = null;
        this.fFollowList = null;
        this.fLeafListType = null;
        this.fElemMapId = null;
    }

    private void calcFollowList(CMNode nodeCur) {
        if (nodeCur.type() == 101) {
            this.calcFollowList(((XSCMBinOp)nodeCur).getLeft());
            this.calcFollowList(((XSCMBinOp)nodeCur).getRight());
        } else if (nodeCur.type() == 102) {
            this.calcFollowList(((XSCMBinOp)nodeCur).getLeft());
            this.calcFollowList(((XSCMBinOp)nodeCur).getRight());
            CMStateSet last = ((XSCMBinOp)nodeCur).getLeft().lastPos();
            CMStateSet first = ((XSCMBinOp)nodeCur).getRight().firstPos();
            for (int index = 0; index < this.fLeafCount; ++index) {
                if (!last.getBit(index)) continue;
                this.fFollowList[index].union(first);
            }
        } else if (nodeCur.type() == 4 || nodeCur.type() == 6) {
            this.calcFollowList(((XSCMUniOp)nodeCur).getChild());
            CMStateSet first = nodeCur.firstPos();
            CMStateSet last = nodeCur.lastPos();
            for (int index = 0; index < this.fLeafCount; ++index) {
                if (!last.getBit(index)) continue;
                this.fFollowList[index].union(first);
            }
        } else if (nodeCur.type() == 5) {
            this.calcFollowList(((XSCMUniOp)nodeCur).getChild());
        }
    }

    private void dumpTree(CMNode nodeCur, int level) {
        for (int index = 0; index < level; ++index) {
            System.out.print("   ");
        }
        int type = nodeCur.type();
        switch (type) {
            case 101: 
            case 102: {
                if (type == 101) {
                    System.out.print("Choice Node ");
                } else {
                    System.out.print("Seq Node ");
                }
                if (nodeCur.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(nodeCur.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(nodeCur.lastPos().toString());
                this.dumpTree(((XSCMBinOp)nodeCur).getLeft(), level + 1);
                this.dumpTree(((XSCMBinOp)nodeCur).getRight(), level + 1);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                System.out.print("Rep Node ");
                if (nodeCur.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(nodeCur.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(nodeCur.lastPos().toString());
                this.dumpTree(((XSCMUniOp)nodeCur).getChild(), level + 1);
                break;
            }
            case 1: {
                System.out.print("Leaf: (pos=" + ((XSCMLeaf)nodeCur).getPosition() + "), " + "(elemIndex=" + ((XSCMLeaf)nodeCur).getLeaf() + ") ");
                if (nodeCur.isNullable()) {
                    System.out.print(" Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(nodeCur.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(nodeCur.lastPos().toString());
                break;
            }
            case 2: {
                System.out.print("Any Node: ");
                System.out.print("firstPos=");
                System.out.print(nodeCur.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(nodeCur.lastPos().toString());
                break;
            }
            default: {
                throw new RuntimeException("ImplementationMessages.VAL_NIICM");
            }
        }
    }

    private int[] makeDefStateList() {
        int[] retArray = new int[this.fElemMapSize];
        for (int index = 0; index < this.fElemMapSize; ++index) {
            retArray[index] = -1;
        }
        return retArray;
    }

    private void postTreeBuildInit(CMNode nodeCur) throws RuntimeException {
        nodeCur.setMaxStates(this.fLeafCount);
        XSCMLeaf leaf = null;
        int pos = 0;
        if (nodeCur.type() == 2) {
            leaf = (XSCMLeaf)nodeCur;
            pos = leaf.getPosition();
            this.fLeafList[pos] = leaf;
            this.fLeafListType[pos] = 2;
        } else if (nodeCur.type() == 101 || nodeCur.type() == 102) {
            this.postTreeBuildInit(((XSCMBinOp)nodeCur).getLeft());
            this.postTreeBuildInit(((XSCMBinOp)nodeCur).getRight());
        } else if (nodeCur.type() == 4 || nodeCur.type() == 6 || nodeCur.type() == 5) {
            this.postTreeBuildInit(((XSCMUniOp)nodeCur).getChild());
        } else if (nodeCur.type() == 1) {
            leaf = (XSCMLeaf)nodeCur;
            pos = leaf.getPosition();
            this.fLeafList[pos] = leaf;
            this.fLeafListType[pos] = 1;
        } else {
            throw new RuntimeException("ImplementationMessages.VAL_NIICM");
        }
    }

    @Override
    public boolean checkUniqueParticleAttribution(SubstitutionGroupHandler subGroupHandler) throws XMLSchemaException {
        int j;
        int i;
        byte[][] conflictTable = new byte[this.fElemMapSize][this.fElemMapSize];
        for (i = 0; i < this.fTransTable.length && this.fTransTable[i] != null; ++i) {
            for (j = 0; j < this.fElemMapSize; ++j) {
                for (int k = j + 1; k < this.fElemMapSize; ++k) {
                    if (this.fTransTable[i][j] == -1 || this.fTransTable[i][k] == -1 || conflictTable[j][k] != 0) continue;
                    conflictTable[j][k] = XSConstraints.overlapUPA(this.fElemMap[j], this.fElemMap[k], subGroupHandler) ? 1 : -1;
                }
            }
        }
        for (i = 0; i < this.fElemMapSize; ++i) {
            for (j = 0; j < this.fElemMapSize; ++j) {
                if (conflictTable[i][j] != 1) continue;
                throw new XMLSchemaException("cos-nonambig", new Object[]{this.fElemMap[i].toString(), this.fElemMap[j].toString()});
            }
        }
        for (i = 0; i < this.fElemMapSize; ++i) {
            if (this.fElemMapType[i] != 2) continue;
            XSWildcardDecl wildcard = (XSWildcardDecl)this.fElemMap[i];
            if (wildcard.fType != 3 && wildcard.fType != 2) continue;
            return true;
        }
        return false;
    }

    @Override
    public Vector whatCanGoHere(int[] state) {
        int curState = state[0];
        if (curState < 0) {
            curState = state[1];
        }
        Vector<Object> ret = new Vector<Object>();
        for (int elemIndex = 0; elemIndex < this.fElemMapSize; ++elemIndex) {
            if (this.fTransTable[curState][elemIndex] == -1) continue;
            ret.addElement(this.fElemMap[elemIndex]);
        }
        return ret;
    }
}

