/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.enums;

import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import com.google.common.collect.Maps;
import java.util.Map;

public enum CDPTypeEnum {
    ODPS("odps", "odps"),
    MYSQL("mysql", "mysql"),
    ORACLE("oracle", "oracle"),
    OTS("ots", "ots"),
    OSS("oss", "oss"),
    SFTP("ftp", "sftp"),
    OCEAN_BASE_NEW("apsaradb_for_oceanbase", "oceanbase_new"),
    DB2("db2", "db2"),
    SQL_SERVER("sqlserver", "sqlserver"),
    ADS("ads", "ads"),
    POSTGRESQL("postgresql", "postgresql"),
    HDFS("hdfs", "hdfs"),
    HBASE("hbase", "hbase");

    private final String D2DataXType;
    private final String CDPDataXType;
    private static final Map<String, CDPTypeEnum> ALL_VALUES;

    public static CDPTypeEnum fromCyjType(String type) {
        if (!ALL_VALUES.containsKey(type)) {
            throw BizException.of((ErrorCode)ErrorCode.UNKNOWN_ENUM_TYPE).with(new Object[]{CDPTypeEnum.class.getSimpleName(), type});
        }
        return ALL_VALUES.get(type);
    }

    private CDPTypeEnum(String d2DataXType, String CDPDataXType) {
        this.D2DataXType = d2DataXType;
        this.CDPDataXType = CDPDataXType;
    }

    public String getCDPDataXType() {
        return this.CDPDataXType;
    }

    public String getD2DataXType() {
        return this.D2DataXType;
    }

    static {
        ALL_VALUES = Maps.newHashMap();
        for (CDPTypeEnum type : CDPTypeEnum.values()) {
            ALL_VALUES.put(type.getCDPDataXType(), type);
        }
    }
}

