/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.assistant.converter;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.NodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.CycleType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.NodeUseType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.RerunMode;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.CronExpressUtil;
import com.aliyun.migration.api.constant.BwmCommonConstant;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.assistant.converter.AbstractDwNodeConverter;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNodeConverter
extends AbstractDwNodeConverter {
    private static final Logger log = LoggerFactory.getLogger(DefaultNodeConverter.class);
    private String defaultPath = "\u4e1a\u52a1\u6d41\u7a0b/%s/%s/";
    private CodeProgramType defaultNodeType = CodeProgramType.VIRTUAL;

    public DefaultNodeConverter() {
    }

    public DefaultNodeConverter(BwmConfiguration taskContextConf) {
        this.taskContextConf = taskContextConf;
    }

    @Override
    public Node convert(WorkflowNode workflowNode) {
        if (Objects.isNull(this.taskContextConf)) {
            this.taskContextConf = BwmConfiguration.newDefault();
        }
        if (workflowNode.getCustomProperties() == null) {
            workflowNode.setCustomProperties(new HashMap());
        }
        if (workflowNode.getRuntimeResource() == null) {
            workflowNode.setRuntimeResource(new HashMap());
        }
        if (workflowNode.getParentTargetIds() == null) {
            workflowNode.setParentTargetIds(new ArrayList());
        }
        Node assistantNode = new Node();
        assistantNode.setName(workflowNode.getNodeName());
        if (StringUtils.isNumeric((CharSequence)workflowNode.getNodeType())) {
            assistantNode.setType(CodeProgramType.getNodeTypeByCode((int)Integer.parseInt(workflowNode.getNodeType())).getName());
        } else {
            assistantNode.setType(this.defaultNodeType.getName());
        }
        assistantNode.setFolder(String.format(this.defaultPath, workflowNode.getWorkflowName(), CodeProgramType.valueOf((String)assistantNode.getType()).getCalcEngineType().getNameCn()));
        if (workflowNode.getTrigger() != null) {
            if (workflowNode.getTrigger().getCron() != null) {
                assistantNode.setCronExpress(workflowNode.getTrigger().getCron());
            }
            if (workflowNode.getTrigger().getStartTime() != null) {
                assistantNode.setStartEffectDate(this.localDatetime2Date(workflowNode.getTrigger().getStartTime()));
            }
            if (workflowNode.getTrigger().getEndTime() != null) {
                assistantNode.setEndEffectDate(this.localDatetime2Date(workflowNode.getTrigger().getEndTime()));
            }
            if (assistantNode.getCronExpress() != null) {
                switch (CronExpressUtil.parseCronToCycleType((String)assistantNode.getCronExpress())) {
                    case 0: {
                        assistantNode.setCycleType(Integer.valueOf(CycleType.DAY.getCode()));
                        break;
                    }
                    case 1: {
                        assistantNode.setCycleType(Integer.valueOf(CycleType.NOT_DAY.getCode()));
                    }
                }
                if (assistantNode.getCronExpress().contains(" ? * ")) {
                    assistantNode.setCycleType(Integer.valueOf(CycleType.DAY.getCode()));
                }
                if (assistantNode.getCronExpress().endsWith(" ?") && !assistantNode.getCronExpress().endsWith("* ?")) {
                    assistantNode.setCycleType(Integer.valueOf(CycleType.DAY.getCode()));
                }
            }
        } else {
            assistantNode.setCycleType(Integer.valueOf(CycleType.NOT_DAY.getCode()));
        }
        assistantNode.setIsAutoParse(Integer.valueOf(Boolean.TRUE.equals(this.taskContextConf.getValue("auto.parsing", (Object)((Boolean)workflowNode.getCustomProperties().get("auto.parsing")), (Object)BwmCommonConstant.Dataworks.AUTO_PARSING_DEFAULT, Boolean.class, BwmServiceErrorCode.CONFIG_ERROR)) ? 1 : 0));
        assistantNode.setResourceGroup((String)this.taskContextConf.getValue("resource.group.identifier", (Object)((String)workflowNode.getRuntimeResource().get("resource.group.identifier")), (Object)"", String.class, BwmServiceErrorCode.CONFIG_ERROR));
        assistantNode.setStartRightNow(Boolean.valueOf(Boolean.TRUE.equals(this.taskContextConf.getValue("startImmediately", (Object)((Boolean)workflowNode.getCustomProperties().get("startImmediately")), (Object)BwmCommonConstant.Dataworks.START_IMMEDIATELY_DEFAULT, Boolean.class, BwmServiceErrorCode.CONFIG_ERROR))));
        assistantNode.setRerunMode(RerunMode.getByValue((int)((Integer)this.taskContextConf.getValue("rerun.mode", (Object)((Integer)workflowNode.getCustomProperties().get("rerun.mode")), (Object)BwmCommonConstant.Dataworks.RERUN_MODE_DEFAULT, Integer.class, BwmServiceErrorCode.CONFIG_ERROR))));
        String schedulerType = (String)this.taskContextConf.getValue("scheduler.type", (Object)((String)workflowNode.getCustomProperties().get("scheduler.type")), (Object)"NORMAL", String.class, BwmServiceErrorCode.CONFIG_ERROR);
        if (schedulerType.equals("NORMAL") || schedulerType.equals("MANUAL") || schedulerType.equals("PAUSE") || schedulerType.equals("SKIP")) {
            schedulerType = "NORMAL";
        }
        switch (schedulerType) {
            case "NORMAL": {
                assistantNode.setPauseSchedule(Boolean.valueOf(false));
                assistantNode.setNodeUseType(NodeUseType.SCHEDULED);
                break;
            }
            case "MANUAL": {
                assistantNode.setPauseSchedule(Boolean.valueOf(false));
                assistantNode.setNodeUseType(NodeUseType.MANUAL);
                assistantNode.setFolder("\u624b\u52a8" + assistantNode.getFolder());
                break;
            }
            case "PAUSE": {
                assistantNode.setPauseSchedule(Boolean.valueOf(true));
                assistantNode.setNodeUseType(NodeUseType.SCHEDULED);
                break;
            }
            case "SKIP": {
                assistantNode.setPauseSchedule(Boolean.valueOf(false));
                assistantNode.setNodeUseType(NodeUseType.SKIP);
            }
        }
        assistantNode.setIsRoot(Boolean.valueOf(false));
        assistantNode.setCode(workflowNode.getScript());
        StringBuilder paraBuilder = new StringBuilder();
        if (workflowNode.getParamMap() != null) {
            for (Map.Entry entry : workflowNode.getParamMap().entrySet()) {
                paraBuilder.append((String)entry.getKey()).append("=").append(entry.getValue()).append(" ");
            }
        }
        assistantNode.setParameter(paraBuilder.toString().trim());
        ArrayList inputList = new ArrayList();
        workflowNode.getParentTargetIds().forEach(projectName_nodeId -> {
            NodeIo input = new NodeIo();
            input.setData(projectName_nodeId);
            inputList.add(input);
        });
        assistantNode.setInputs(inputList);
        ArrayList<NodeIo> outputList = new ArrayList<NodeIo>();
        outputList.add(new NodeIo(String.format("%s.%s_out", workflowNode.getProjectName(), workflowNode.getNodeId())));
        assistantNode.setOutputs(outputList);
        assistantNode.setDescription(workflowNode.getDescription());
        assistantNode.setTaskRerunTime((Integer)this.taskContextConf.getValue("auto.rerun.times", (Object)((Integer)workflowNode.getCustomProperties().get("auto.rerun.times")), (Object)BwmCommonConstant.Dataworks.AUTO_RERUN_TIMES_DEFAULT, Integer.class, BwmServiceErrorCode.CONFIG_ERROR));
        assistantNode.setTaskRerunInterval((Integer)this.taskContextConf.getValue("auto.rerun.interval.millis", (Object)((Integer)workflowNode.getCustomProperties().get("auto.rerun.interval.millis")), (Object)BwmCommonConstant.Dataworks.AUTO_RERUN_INTERVAL_MILLIS_DEFAULT, Integer.class, BwmServiceErrorCode.CONFIG_ERROR));
        assistantNode.setDependentType(Integer.valueOf(0));
        assistantNode.setMultiInstCheckType(Integer.valueOf(0));
        assistantNode.setPriority(Integer.valueOf(1));
        return assistantNode;
    }

    private Date localDatetime2Date(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        try {
            return new Date(localDateTime.toInstant(ZoneOffset.ofTotalSeconds(0)).toEpochMilli());
        }
        catch (Exception e) {
            log.error("invalid start time in node");
            return null;
        }
    }

    private Boolean cycleTypeIsDay(String cron) {
        String[] cronPart = cron.split(" ");
        if (cronPart.length != 6) {
            return true;
        }
        String regex = "^[0-9,\\-/]*$";
        if (cronPart[0].matches(regex) && cronPart[1].matches(regex) && cronPart[2].matches(regex) && cronPart[3].equals("*") && cronPart[4].equals("*") && cronPart[5].equals("?")) {
            return true;
        }
        return false;
    }
}

