/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.workflow.migration.core;

import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.api.exception.EngineClosedException;
import com.aliyun.workflow.migration.core.Task;
import com.aliyun.workflow.migration.core.callback.FutureCallback;
import com.aliyun.workflow.migration.core.callback.LogCallback;
import com.aliyun.workflow.migration.core.callback.TaskStatisticPrintCallback;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Engine<T extends Task> {
    private static final Logger log = LoggerFactory.getLogger(Engine.class);
    private final Map<String, List<T>> hasRunningTask = new ConcurrentHashMap<String, List<T>>();
    private final LinkedList<FutureCallback<T>> callbacks = new LinkedList();
    private volatile boolean stop = false;

    public Engine() {
        this.callbacks.addFirst(new LogCallback());
    }

    protected void registerCallBack(FutureCallback<T> callback) {
        this.callbacks.add(callback);
    }

    protected void shutDown() {
        this.stop = true;
        for (Map.Entry<String, List<T>> entry : this.hasRunningTask.entrySet()) {
            List<T> value = entry.getValue();
            int size = value.size();
            if (size <= 0) continue;
            ((Task)value.get(size - 1)).kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killJob(String jobId) {
        Engine engine = this;
        synchronized (engine) {
            List<T> runningTask = this.hasRunningTask.remove(jobId);
            if (runningTask == null) {
                log.info("KIll\u7684\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u5b8c\u6210\uff1a{}", (Object)jobId);
                return;
            }
            if (runningTask.size() == 0) {
                log.info("KIll\u7684\u4efb\u52a1\u8fd8\u672a\u5f00\u59cb\u6267\u884c\uff0cKILL\u6210\u529f\uff1a{}", (Object)jobId);
                return;
            }
            int size = runningTask.size() - 1;
            Task t = (Task)runningTask.get(size);
            t.kill();
            log.info("KILL\u6210\u529f\uff1a{}", (Object)jobId);
        }
    }

    public Result launch(@Nonnull List<T> tasks, @Nonnull String jobId) {
        Result result;
        if (this.stop) {
            return Result.getFailure((Throwable)new EngineClosedException());
        }
        try {
            result = this.runTask(tasks, jobId);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return Result.getFailure(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result runTask(List<T> tasks, String jobId) {
        Result result;
        List<T> remove;
        int index;
        if (tasks.isEmpty()) {
            return Result.getFailure(new Exception("\u6ca1\u6709\u6267\u884c\u7684\u4efb\u52a1"));
        }
        Object ex = null;
        Boolean ans = true;
        HashSet<Integer> skipIndex = new HashSet<Integer>();
        boolean init = true;
        for (index = 0; index < tasks.size() && !this.stop; ++index) {
            Task task = (Task)tasks.get(index);
            try {
                if (!task.init()) {
                    log.warn("JobId:{},\u4efb\u52a1{}\uff0c\u7531\u4e8e\u6ca1\u6709\u5bf9\u5e94\u7684\u63d2\u4ef6\u8df3\u8fc7\uff01", (Object)task.getJobID(), (Object)task.getTaskID());
                    skipIndex.add(index);
                    continue;
                }
                task.setTaskStartTimeMS(System.currentTimeMillis());
            }
            catch (Throwable throwable) {
                log.error("\u521d\u59cb\u5316\u4efb\u52a1\u5931\u8d25\uff1a", throwable);
                ex = BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.INIT_FAILED, (String)BwmServiceErrorCode.INIT_FAILED.getDescription(), (Throwable)throwable);
                ans = false;
                break;
            }
            Engine throwable = this;
            synchronized (throwable) {
                List<T> ts;
                if (init) {
                    this.hasRunningTask.put(jobId, new ArrayList());
                    init = false;
                }
                if ((ts = this.hasRunningTask.get(jobId)) == null) {
                    ex = BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.TASK_KILL, (String)("\u4efb\u52a1\uff1a" + jobId + ",\u88abkill"));
                    ans = false;
                    break;
                }
                ts.add(task);
            }
            try {
                ans = (Boolean)task.call();
            }
            catch (Exception e) {
                ex = e;
            }
            if (ex != null || !ans.booleanValue()) {
                ans = false;
                break;
            }
            task.setTaskEndTimeMS(System.currentTimeMillis());
            log.info("{}-{}\u6267\u884c\u6210\u529f", (Object)task.getJobID(), (Object)task.getTaskID());
        }
        if ((remove = this.hasRunningTask.remove(jobId)) == null && index != skipIndex.size()) {
            log.warn("\u6536\u5230KILL\u547d\u4ee4\uff0c\u4f46\u662f\u4efb\u52a1\u5df2\u6267\u884c\u5b8c\u6210\uff0c\u6700\u7ec8\u72b6\u6001\u4e0d\u4f1a\u662fKILL");
        }
        if (this.stop) {
            ex = new EngineClosedException();
        } else if (!ans.booleanValue() && ex == null) {
            ex = BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.TASK_KILL, (String)("\u4efb\u52a1\uff1a" + jobId + ",\u88abkill"));
        }
        if (!ans.booleanValue()) {
            result = this.callFailure(tasks, (Throwable)ex, index, skipIndex);
        } else {
            result = new Result(true);
            try {
                for (int i = 0; i < index; ++i) {
                    Task task = (Task)tasks.get(i);
                    if (skipIndex.contains(i)) {
                        log.warn("JobId:{},\u4efb\u52a1{}\uff0c\u7531\u4e8e\u6ca1\u6709\u8f93\u5165\u8def\u5f84\u8df3\u8fc7\uff0c\u6240\u4ee5\u4efb\u52a1\u672a\u88ab\u6267\u884c\uff0c\u65e0\u9700\u6267\u884c\u56de\u8c03\uff01", (Object)task.getJobID(), (Object)task.getTaskID());
                        continue;
                    }
                    for (FutureCallback futureCallback : this.callbacks) {
                        futureCallback.onSuccess(task, result);
                    }
                }
            }
            catch (Throwable e) {
                log.error("\u6267\u884csuccess\u56de\u8c03\u51fa\u9519", e);
                result = this.callFailure(tasks, e, index, skipIndex);
            }
        }
        if (result.isOk) {
            try {
                TaskStatisticPrintCallback<T> printCallback = new TaskStatisticPrintCallback<T>();
                printCallback.onSuccess(tasks, result);
            }
            catch (Exception e) {
                log.error("\u6267\u884cTaskStatisticPrintCallback\u56de\u8c03\u51fa\u9519", (Throwable)e);
                result = Result.getFailure(e);
            }
        }
        return result;
    }

    private Result callFailure(List<T> tasks, Throwable ex, int index, Set<Integer> skipIndex) {
        index = Math.min(index, tasks.size() - 1);
        for (int i = 0; i <= index; ++i) {
            Task task = (Task)tasks.get(i);
            if (skipIndex.contains(i)) {
                log.warn("JobId:{},\u4efb\u52a1{}\uff0c\u7531\u4e8e\u6ca1\u6709\u8f93\u5165\u8def\u5f84\u8df3\u8fc7\uff0c\u6240\u4ee5\u4efb\u52a1\u672a\u88ab\u6267\u884c\uff0c\u65e0\u9700\u6267\u884c\u56de\u8c03\uff01", (Object)task.getJobID(), (Object)task.getTaskID());
                continue;
            }
            for (FutureCallback futureCallback : this.callbacks) {
                try {
                    futureCallback.onFailure(task, ex);
                }
                catch (Exception e) {
                    log.error("\u6267\u884c{}\u56de\u8c03\u5f02\u5e38\uff0c\u540e\u7eed\u56de\u8c03\u7ee7\u7eed\u6267\u884c", (Object)futureCallback, (Object)e);
                }
            }
        }
        if (ex instanceof EngineClosedException) {
            log.debug("\u4efb\u52a1\u6267\u884c\u51fa\u9519\uff1a{}", (Object)((Task)tasks.get(0)).getJobID(), (Object)ex);
        } else {
            log.error("\u4efb\u52a1\u6267\u884c\u51fa\u9519\uff1a{}", (Object)((Task)tasks.get(0)).getJobID(), (Object)ex);
        }
        return Result.getFailure(ex);
    }

    public static class Result {
        private final boolean isOk;
        private Throwable throwable;

        public Result(boolean isOk, Throwable throwable) {
            this.isOk = isOk;
            this.throwable = throwable;
        }

        public Result(boolean isOk) {
            this.isOk = isOk;
        }

        public static Result getFailure(Throwable throwable) {
            return new Result(false, throwable);
        }
    }
}

