/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.api.loggers.appenders;

import com.alibaba.securitysdk.logging.api.Level;
import com.alibaba.securitysdk.logging.api.configurations.LogConfig;
import com.alibaba.securitysdk.logging.api.loggers.appenders.Appender;
import com.alibaba.securitysdk.logging.utils.AssertUtil;
import com.alibaba.securitysdk.logging.utils.IoUtils;
import com.alibaba.securitysdk.logging.utils.QuietWriter;
import com.alibaba.securitysdk.logging.utils.Throwables;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FileAppender
implements Appender {
    private static final String DEFAULT_ENCODING = "utf-8";
    private static final boolean DEFAULT_FILE_APPEND = true;
    private static final boolean DEFAULT_IMMEDIATE_WRITE = true;
    private static final SimpleDateFormat SDF = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final String LOG_FORMAT = "SECURITY SDK: %s %s\n";
    private static final long DEFAULT_MAX_FILE_SIZE_MB = 0x8000000L;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private QuietWriter quietWriter;
    private LogConfig logConfig;
    private String name;
    protected boolean fileAppend = true;
    protected String fileName;
    private boolean immediateFlush = true;
    private long bufferSize = 8192L;

    public FileAppender(String name, String fileName) throws IOException {
        this.name = name;
        this.setFile(fileName, true, true, 8192L);
    }

    public FileAppender(String name, LogConfig logConfig) throws IOException {
        this.name = name;
        this.logConfig = logConfig;
        this.setFile((String)AssertUtil.notNull((Object)logConfig.getFileName()), true, true, 8192L);
    }

    public FileAppender(String name, String filename, boolean append, boolean immediateFlush, long bufferSize, LogConfig logConfig) throws IOException {
        this.name = name;
        this.logConfig = logConfig;
        this.setFile(filename, append, immediateFlush, bufferSize);
    }

    private synchronized void setFile(String fileName, boolean append, boolean immediateFlush, long bufferSize) throws IOException {
        FileOutputStream fileOutputStream = IoUtils.createFileOuputStream((String)fileName, (boolean)append);
        this.quietWriter = new QuietWriter((Writer)IoUtils.createOutputStreamWriter((OutputStream)fileOutputStream, (String)DEFAULT_ENCODING));
        this.fileName = fileName;
        this.immediateFlush = immediateFlush;
        this.bufferSize = bufferSize;
    }

    protected synchronized void setFile(String fileName) throws IOException {
        FileOutputStream fileOutputStream = IoUtils.createFileOuputStream((String)fileName, (boolean)this.fileAppend);
        this.quietWriter = new QuietWriter((Writer)IoUtils.createOutputStreamWriter((OutputStream)fileOutputStream, (String)DEFAULT_ENCODING));
        this.fileName = fileName;
    }

    @Override
    public void append(Level level, String message, Throwable throwable, Object[] args) {
        if (this.checkCondition()) {
            return;
        }
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append(level);
        stringBuffer.append(" (");
        stringBuffer.append(this.name);
        stringBuffer.append(") - ");
        this.replaceBrace(message, stringBuffer, args);
        this.renderThrowable(throwable, stringBuffer);
        this.printMessage(stringBuffer.toString());
        if (this.immediateFlush) {
            this.quietWriter.flush();
        }
    }

    private boolean checkCondition() {
        return new File(this.fileName).length() >= 0x8000000L;
    }

    private void replaceBrace(String message, StringBuilder stringBuffer, Object[] args) {
        int last = 0;
        for (Object arg : args) {
            int index = message.indexOf("{}");
            if (index < 0) continue;
            stringBuffer.append(message.substring(last, index)).append(String.valueOf(arg)).append(message.substring(index + 2));
            last = index + 2;
        }
        stringBuffer.append(message.substring(last, message.length()));
    }

    private void renderThrowable(Throwable throwable, StringBuilder stringBuffer) {
        if (throwable != null) {
            stringBuffer.append("\n");
            int stackTopDepth = this.logConfig.getStackTopDepth();
            int stackBottomDepth = this.logConfig.getStackBottomDepth();
            stringBuffer.append(Throwables.stackTraceAsString((Throwable)throwable, (int)stackTopDepth, (int)stackBottomDepth));
        }
    }

    private void printMessage(String msg) {
        String log = String.format(LOG_FORMAT, SDF.format(new Date()), msg);
        if (this.quietWriter != null) {
            this.quietWriter.write(log);
        }
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setQuietWriter(QuietWriter quietWriter) {
        this.quietWriter = quietWriter;
    }

    public void setLogConfig(LogConfig logConfig) {
        this.logConfig = logConfig;
    }

    public void setFileAppend(boolean fileAppend) {
        this.fileAppend = fileAppend;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setImmediateFlush(boolean immediateFlush) {
        this.immediateFlush = immediateFlush;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public QuietWriter getQuietWriter() {
        return this.quietWriter;
    }

    public LogConfig getLogConfig() {
        return this.logConfig;
    }

    public boolean isFileAppend() {
        return this.fileAppend;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    public long getBufferSize() {
        return this.bufferSize;
    }
}

