/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.convert;

import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.spec.domain.dataworks.node.DataWorksNodeTypeUtils;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.type.DmsDatasourceType;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalSqlNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(NormalSqlNodeConvert.class);

    public NormalSqlNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext, workflow);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNodes.get(0), WorkflowNode.class);
        if (StringUtils.isNotBlank((CharSequence)workflowNode.getDbType())) {
            DmsDatasourceType dmsDatasourceType = DmsDatasourceType.of((String)workflowNode.getDbType());
            if (dmsDatasourceType == null) {
                workflowNode.setNodeType(DataWorksNodeTypeUtils.CustomCodeProgramType.COMPONENT_SQL.getName());
            } else {
                switch (dmsDatasourceType) {
                    case LINDORM_SQL: {
                        workflowNode.setNodeType(DataWorksNodeTypeUtils.CustomCodeProgramType.LINDORM_OLAP.getName());
                        this.supplyDatasourceWithoutSchema(workflowNode);
                        break;
                    }
                    case ADB_MYSQL: {
                        workflowNode.setNodeType(DataWorksNodeTypeUtils.CustomCodeProgramType.ADB_for_MySQL.getName());
                        this.supplyDatasourceWithSchema(workflowNode);
                        break;
                    }
                    case ADB_PG: {
                        workflowNode.setNodeType(DataWorksNodeTypeUtils.CustomCodeProgramType.ADB_for_PostgreSQL.getName());
                        this.supplyDatasourceWithSchema(workflowNode);
                        break;
                    }
                    case CLICKHOUSE: {
                        workflowNode.setNodeType(DataWorksNodeTypeUtils.CustomCodeProgramType.CLICK_SQL.getName());
                        this.supplyDatasourceWithSchema(workflowNode);
                        break;
                    }
                    case POSTGRESQL: {
                        workflowNode.setNodeType(DataWorksNodeTypeUtils.CustomCodeProgramType.POSTGRESQL.getName());
                        this.supplyDatasourceWithSchema(workflowNode);
                        break;
                    }
                    case SELECTDB: {
                        workflowNode.setNodeType(DataWorksNodeTypeUtils.CustomCodeProgramType.Selectdb.getName());
                        this.supplyDatasourceWithSchema(workflowNode);
                        break;
                    }
                    case SQLSERVER: {
                        workflowNode.setNodeType(DataWorksNodeTypeUtils.CustomCodeProgramType.SQLSERVER.getName());
                        this.supplyDatasourceWithSchema(workflowNode);
                        break;
                    }
                    case MYSQL: {
                        workflowNode.setNodeType(DataWorksNodeTypeUtils.CustomCodeProgramType.MYSQL.getName());
                        this.supplyDatasourceWithSchema(workflowNode);
                        break;
                    }
                    default: {
                        workflowNode.setNodeType(DataWorksNodeTypeUtils.CustomCodeProgramType.COMPONENT_SQL.getName());
                        this.supplyDatasourceWithSchema(workflowNode);
                    }
                }
            }
        }
        return List.of(workflowNode);
    }

    private void supplyDatasourceWithSchema(WorkflowNode workflowNode) {
        if (CollectionUtils.isNotEmpty((Collection)workflowNode.getDataSources())) {
            String datasourceName = ((WorkflowDatasource)workflowNode.getDataSources().get(0)).getName();
            if (workflowNode.getCustomProperties() == null) {
                workflowNode.setCustomProperties(new HashMap());
            }
            workflowNode.getCustomProperties().put("datasource", NormalSqlNodeConvert.replaceInvalidCharsWithUnderscore(datasourceName));
        }
    }

    private void supplyDatasourceWithoutSchema(WorkflowNode workflowNode) {
        if (CollectionUtils.isNotEmpty((Collection)workflowNode.getDataSources())) {
            String datasourceName = ((WorkflowDatasource)workflowNode.getDataSources().get(0)).getName();
            if (workflowNode.getCustomProperties() == null) {
                workflowNode.setCustomProperties(new HashMap());
            }
            if (datasourceName.contains("#")) {
                datasourceName = datasourceName.substring(0, datasourceName.indexOf("#"));
            }
            workflowNode.getCustomProperties().put("datasource", NormalSqlNodeConvert.replaceInvalidCharsWithUnderscore(datasourceName));
        }
    }

    public static String replaceInvalidCharsWithUnderscore(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("[^a-zA-Z0-9_]", "_");
    }
}

