/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.convert;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.spec.domain.dataworks.node.DataWorksNodeTypeUtils;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LindormSparkNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(LindormSparkNodeConvert.class);

    public LindormSparkNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext, workflow);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNodes.get(0), WorkflowNode.class);
        if (MapUtils.isNotEmpty((Map)workflowNode.getCustomProperties()) && workflowNode.getCustomProperties().containsKey("jobType") && StringUtils.isNotBlank((CharSequence)((String)workflowNode.getCustomProperties().get("jobType")))) {
            switch ((String)workflowNode.getCustomProperties().get("jobType")) {
                case "sql": {
                    workflowNode.setNodeType(DataWorksNodeTypeUtils.CustomCodeProgramType.LINDORM_SPARK_SQL.getName());
                    this.supplyDatasourceWithoutSchema(workflowNode);
                    JSONObject sparkConfMap = this.getSparkConfMap(workflowNode);
                    if (workflowNode.getCustomProperties() == null) {
                        workflowNode.setCustomProperties(new HashMap());
                    }
                    workflowNode.getCustomProperties().put("sparkConf", sparkConfMap.toJSONString(new JSONWriter.Feature[0]));
                }
            }
        }
        return List.of(workflowNode);
    }

    private void supplyDatasourceWithoutSchema(WorkflowNode workflowNode) {
        if (CollectionUtils.isNotEmpty((Collection)workflowNode.getDataSources())) {
            String datasourceName = ((WorkflowDatasource)workflowNode.getDataSources().get(0)).getName();
            if (workflowNode.getCustomProperties() == null) {
                workflowNode.setCustomProperties(new HashMap());
            }
            if (datasourceName.contains("#")) {
                datasourceName = datasourceName.substring(0, datasourceName.indexOf("#"));
            }
            workflowNode.getCustomProperties().put("datasource", datasourceName);
        }
    }

    public JSONObject getSparkConfMap(WorkflowNode node) {
        if (MapUtils.isNotEmpty((Map)node.getCustomProperties()) && node.getCustomProperties().containsKey("configs")) {
            JSONObject configs = new JSONObject();
            if (node.getCustomProperties().get("configs") instanceof JSONObject) {
                configs = (JSONObject)node.getCustomProperties().get("configs");
            } else if (node.getCustomProperties().get("configs") instanceof String) {
                configs = JSONObject.parseObject((String)((String)node.getCustomProperties().get("configs")));
            }
            if (configs.containsKey("configs")) {
                return configs.getJSONObject("configs");
            }
        }
        return new JSONObject();
    }
}

