/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.convert;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.spec.domain.dataworks.node.DataWorksNodeTypeUtils;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyCheckNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(DependencyCheckNodeConvert.class);

    public DependencyCheckNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext, workflow);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        WorkflowNode workflowNode;
        block9: {
            if (CollectionUtils.isEmpty(workflowNodes)) {
                log.warn("node convert workflowNodes is null");
                return new ArrayList<WorkflowNode>();
            }
            workflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNodes.get(0), WorkflowNode.class);
            workflowNode.setNodeType(DataWorksNodeTypeUtils.CustomCodeProgramType.VIRTUAL.getName());
            if (!StringUtils.isNotBlank((CharSequence)workflowNode.getScript())) break block9;
            JSONObject content = JSONObject.parseObject((String)workflowNode.getScript());
            String dependentDAGId = content.getString("dependentDAGId");
            String dependentNodeId = content.getString("dependentNodeId");
            if (!StringUtils.isNotBlank((CharSequence)dependentDAGId)) break block9;
            for (Workflow wf : this.taskContext.getWorkflowProjectPackage().getWorkflowList()) {
                if (!wf.getWorkflowId().equals(dependentDAGId)) continue;
                if (StringUtils.isNotBlank((CharSequence)dependentNodeId)) {
                    if (CollectionUtils.isNotEmpty((Collection)wf.getWorkflowNodes())) {
                        for (WorkflowNode node : wf.getWorkflowNodes()) {
                            if (!node.getNodeId().equals(dependentNodeId)) continue;
                            RelationPackage relationPackage = new RelationPackage();
                            relationPackage.setFrom(node.getNodeId());
                            relationPackage.setTo(workflowNode.getNodeId());
                            relationPackage.setReType(RelationPackage.ReType.NODE);
                            if (this.workflow.getNodeRelations() == null) {
                                this.workflow.setNodeRelations(new ArrayList());
                            }
                            this.workflow.getNodeRelations().add(relationPackage);
                            break;
                        }
                    }
                } else {
                    RelationPackage relationPackage = new RelationPackage();
                    relationPackage.setFrom(dependentDAGId);
                    relationPackage.setTo(workflowNode.getNodeId());
                    relationPackage.setReType(RelationPackage.ReType.WORKFLOW_NODE);
                    if (this.workflow.getNodeRelations() == null) {
                        this.workflow.setNodeRelations(new ArrayList());
                    }
                    this.workflow.getNodeRelations().add(relationPackage);
                }
                workflowNode.setScript(null);
                break;
            }
        }
        return List.of(workflowNode);
    }
}

