/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

public class PatternLayoutEscaped
extends PatternLayout {
    public PatternLayoutEscaped(String s) {
        super(s);
    }

    public PatternLayoutEscaped() {
    }

    public String format(LoggingEvent event) {
        if (event.getMessage() instanceof String) {
            return super.format(this.appendStackTraceToEvent(event));
        }
        return super.format(event);
    }

    private LoggingEvent appendStackTraceToEvent(LoggingEvent event) {
        String message = event.getMessage().toString();
        if (event.getThrowableInformation() != null) {
            String[] s;
            for (String line : s = event.getThrowableStrRep()) {
                message = message + "\n" + line;
            }
        }
        message = message.replace("\\", "\\\\").replace("\n", "\\n").replace("\"", "\\\"").replace("\t", "\\t");
        Throwable throwable = event.getThrowableInformation() == null ? null : event.getThrowableInformation().getThrowable();
        return new LoggingEvent(event.getFQNOfLoggerClass(), event.getLogger(), event.getTimeStamp(), (Priority)event.getLevel(), (Object)message, throwable);
    }
}

