/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger.builtin;

import azkaban.ServiceProvider;
import azkaban.alert.Alerter;
import azkaban.executor.AlerterHolder;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutorLoader;
import azkaban.sla.SlaOption;
import azkaban.trigger.TriggerAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SlaAlertAction
implements TriggerAction {
    public static final String type = "AlertAction";
    private static final Logger logger = Logger.getLogger(SlaAlertAction.class);
    private final String actionId;
    private final SlaOption slaOption;
    private final int execId;
    private final AlerterHolder alerters;
    private final ExecutorLoader executorLoader;

    public SlaAlertAction(String id, SlaOption slaOption, int execId) {
        this.actionId = id;
        this.slaOption = slaOption;
        this.execId = execId;
        this.alerters = ServiceProvider.SERVICE_PROVIDER.getInstance(AlerterHolder.class);
        this.executorLoader = ServiceProvider.SERVICE_PROVIDER.getInstance(ExecutorLoader.class);
    }

    public static SlaAlertAction createFromJson(Object obj) throws Exception {
        return SlaAlertAction.createFromJson((HashMap)obj);
    }

    public static SlaAlertAction createFromJson(HashMap<String, Object> obj) throws Exception {
        HashMap<String, Object> jsonObj = obj;
        if (!jsonObj.get("type").equals(type)) {
            throw new Exception("Cannot create action of AlertAction from " + jsonObj.get("type"));
        }
        String actionId = (String)jsonObj.get("actionId");
        SlaOption slaOption = SlaOption.fromObject(jsonObj.get("slaOption"));
        int execId = Integer.valueOf((String)jsonObj.get("execId"));
        return new SlaAlertAction(actionId, slaOption, execId);
    }

    @Override
    public String getId() {
        return this.actionId;
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public TriggerAction fromJson(Object obj) throws Exception {
        return SlaAlertAction.createFromJson(obj);
    }

    @Override
    public Object toJson() {
        HashMap<String, Object> jsonObj = new HashMap<String, Object>();
        jsonObj.put("actionId", this.actionId);
        jsonObj.put("type", type);
        jsonObj.put("slaOption", this.slaOption.toObject());
        jsonObj.put("execId", String.valueOf(this.execId));
        return jsonObj;
    }

    @Override
    public void doAction() throws Exception {
        logger.info((Object)"Alerting on sla failure.");
        Map<String, Object> alert = this.slaOption.getInfo();
        if (alert.containsKey("SlaAlertType")) {
            String alertType = (String)alert.get("SlaAlertType");
            Alerter alerter = this.alerters.get(alertType);
            if (alerter != null) {
                try {
                    ExecutableFlow flow = this.executorLoader.fetchExecutableFlow(this.execId);
                    alerter.alertOnSla(this.slaOption, SlaOption.createSlaMessage(this.slaOption, flow));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error((Object)("Failed to alert by " + alertType));
                }
            } else {
                logger.error((Object)("Alerter type " + alertType + " doesn't exist. Failed to alert."));
            }
        }
    }

    @Override
    public void setContext(Map<String, Object> context) {
    }

    @Override
    public String getDescription() {
        return "AlertAction for " + this.execId + " with " + this.slaOption.toString();
    }
}

