/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger;

import azkaban.trigger.CheckerTypeLoader;
import azkaban.trigger.ConditionChecker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;

public class Condition {
    private static final Logger logger = Logger.getLogger(Condition.class);
    private static final JexlEngine jexl = new JexlEngine();
    private static CheckerTypeLoader checkerLoader = null;
    private final MapContext context = new MapContext();
    private Expression expression;
    private Map<String, ConditionChecker> checkers = new HashMap<String, ConditionChecker>();
    private Long nextCheckTime = -1L;

    public Condition(Map<String, ConditionChecker> checkers, String expr) {
        this.setCheckers(checkers);
        this.expression = jexl.createExpression(expr);
        this.updateNextCheckTime();
    }

    public Condition(Map<String, ConditionChecker> checkers, String expr, long nextCheckTime) {
        this.nextCheckTime = nextCheckTime;
        this.setCheckers(checkers);
        this.expression = jexl.createExpression(expr);
    }

    public static synchronized void setCheckerLoader(CheckerTypeLoader loader) {
        checkerLoader = loader;
    }

    public static Condition fromJson(Object obj) throws Exception {
        if (checkerLoader == null) {
            throw new Exception("Condition Checker loader not initialized!");
        }
        HashMap jsonObj = (HashMap)obj;
        Condition cond = null;
        try {
            HashMap<String, ConditionChecker> checkers = new HashMap<String, ConditionChecker>();
            List checkersJson = (List)jsonObj.get("checkers");
            for (Object oneCheckerJson : checkersJson) {
                HashMap oneChecker = (HashMap)oneCheckerJson;
                String type = (String)oneChecker.get("type");
                ConditionChecker ck = checkerLoader.createCheckerFromJson(type, oneChecker.get("checkerJson"));
                checkers.put(ck.getId(), ck);
            }
            String expr = (String)jsonObj.get("expression");
            Long nextCheckTime = Long.valueOf((String)jsonObj.get("nextCheckTime"));
            cond = new Condition(checkers, expr, nextCheckTime);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"Failed to recreate condition from json.", (Throwable)e);
            throw new Exception("Failed to recreate condition from json.", e);
        }
        return cond;
    }

    public long getNextCheckTime() {
        return this.nextCheckTime;
    }

    public Map<String, ConditionChecker> getCheckers() {
        return this.checkers;
    }

    private void setCheckers(Map<String, ConditionChecker> checkers) {
        this.checkers = checkers;
        for (ConditionChecker checker : checkers.values()) {
            this.context.set(checker.getId(), (Object)checker);
        }
        this.updateNextCheckTime();
    }

    private void updateNextCheckTime() {
        long time = Long.MAX_VALUE;
        for (ConditionChecker checker : this.checkers.values()) {
            time = Math.min(time, checker.getNextCheckTime());
        }
        this.nextCheckTime = time;
    }

    public void resetCheckers() {
        for (ConditionChecker checker : this.checkers.values()) {
            checker.reset();
        }
        this.updateNextCheckTime();
        logger.info((Object)("Done resetting checkers. The next check time will be " + new DateTime((Object)this.nextCheckTime)));
    }

    public String getExpression() {
        return this.expression.getExpression();
    }

    public void setExpression(String expr) {
        this.expression = jexl.createExpression(expr);
    }

    public boolean isMet() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Testing condition " + this.expression));
        }
        return this.expression.evaluate((JexlContext)this.context).equals(Boolean.TRUE);
    }

    public Object toJson() {
        HashMap<String, Object> jsonObj = new HashMap<String, Object>();
        jsonObj.put("expression", this.expression.getExpression());
        ArrayList checkersJson = new ArrayList();
        for (ConditionChecker checker : this.checkers.values()) {
            HashMap<String, Object> oneChecker = new HashMap<String, Object>();
            oneChecker.put("type", checker.getType());
            oneChecker.put("checkerJson", checker.toJson());
            checkersJson.add(oneChecker);
        }
        jsonObj.put("checkers", checkersJson);
        jsonObj.put("nextCheckTime", String.valueOf(this.nextCheckTime));
        return jsonObj;
    }
}

