/*
 * Decompiled with CFR 0.152.
 */
package azkaban.storage;

import azkaban.AzkabanCommonModuleConfig;
import azkaban.spi.Storage;
import azkaban.spi.StorageException;
import azkaban.spi.StorageMetadata;
import azkaban.utils.FileIOUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

@Singleton
public class LocalStorage
implements Storage {
    private static final Logger log = Logger.getLogger(LocalStorage.class);
    final File rootDirectory;

    @Inject
    public LocalStorage(AzkabanCommonModuleConfig config) {
        this.rootDirectory = LocalStorage.validateRootDirectory(LocalStorage.createIfDoesNotExist(config.getLocalStorageBaseDirPath()));
    }

    private static File createIfDoesNotExist(String baseDirectoryPath) {
        File baseDirectory = new File(baseDirectoryPath);
        if (!baseDirectory.exists()) {
            baseDirectory.mkdir();
            log.info((Object)("Creating dir: " + baseDirectory.getAbsolutePath()));
        }
        return baseDirectory;
    }

    private static File validateRootDirectory(File baseDirectory) {
        Preconditions.checkArgument((boolean)baseDirectory.isDirectory());
        if (!FileIOUtils.isDirWritable(baseDirectory)) {
            throw new IllegalArgumentException("Directory not writable: " + baseDirectory);
        }
        return baseDirectory;
    }

    private File getFile(String key) {
        return new File(this.rootDirectory, key);
    }

    public InputStream get(String key) throws IOException {
        return new FileInputStream(this.getFile(key));
    }

    public String put(StorageMetadata metadata, File localFile) {
        File targetFile;
        File projectDir = new File(this.rootDirectory, String.valueOf(metadata.getProjectId()));
        if (projectDir.mkdir()) {
            log.info((Object)("Created project dir: " + projectDir.getAbsolutePath()));
        }
        if ((targetFile = new File(projectDir, String.format("%s-%s.zip", String.valueOf(metadata.getProjectId()), new String(Hex.encodeHex((byte[])metadata.getHash()))))).exists()) {
            log.info((Object)String.format("Duplicate found: meta: %s, targetFile: %s, ", metadata, targetFile.getAbsolutePath()));
            return this.getRelativePath(targetFile);
        }
        try {
            FileUtils.copyFile((File)localFile, (File)targetFile);
        }
        catch (IOException e) {
            log.error((Object)("LocalStorage error in put(): meta: " + metadata));
            throw new StorageException((Throwable)e);
        }
        return this.getRelativePath(targetFile);
    }

    private String getRelativePath(File targetFile) {
        return this.rootDirectory.toURI().relativize(targetFile.toURI()).getPath();
    }

    public boolean delete(String key) {
        boolean result;
        File file = this.getFile(key);
        boolean bl = result = file.exists() && file.delete();
        if (result) {
            log.warn((Object)("Deleted file: " + file.getAbsolutePath()));
        } else {
            log.warn((Object)("Unable to delete file: " + file.getAbsolutePath()));
        }
        return result;
    }
}

