/*
 * Decompiled with CFR 0.152.
 */
package azkaban.project;

import azkaban.utils.Props;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ProjectWhitelist {
    public static final String XML_FILE_PARAM = "project.whitelist.xml.file";
    private static final String PROJECT_WHITELIST_TAG = "ProjectWhitelist";
    private static final String PROJECT_TAG = "project";
    private static final String PROJECTID_ATTR = "projectid";
    private static final AtomicReference<Map<WhitelistType, Set<Integer>>> projectsWhitelisted = new AtomicReference();

    static void load(Props props) {
        String xmlFile = props.getString(XML_FILE_PARAM);
        ProjectWhitelist.parseXMLFile(xmlFile);
    }

    private static void parseXMLFile(String xmlFile) {
        File file = new File(xmlFile);
        if (!file.exists()) {
            throw new IllegalArgumentException("Project whitelist xml file " + xmlFile + " doesn't exist.");
        }
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException("Exception while parsing project whitelist xml. Document builder not created.", e);
        }
        Document doc = null;
        try {
            doc = builder.parse(file);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("Exception while parsing " + xmlFile + ". Invalid XML.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Exception while parsing " + xmlFile + ". Error reading file.", e);
        }
        HashMap<WhitelistType, HashSet<Integer>> projsWhitelisted = new HashMap<WhitelistType, HashSet<Integer>>();
        NodeList tagList = doc.getChildNodes();
        if (!tagList.item(0).getNodeName().equals(PROJECT_WHITELIST_TAG)) {
            throw new RuntimeException("Cannot find tag 'ProjectWhitelist' in " + xmlFile);
        }
        NodeList whitelist = tagList.item(0).getChildNodes();
        for (int n = 0; n < whitelist.getLength(); ++n) {
            if (whitelist.item(n).getNodeType() != 1) continue;
            String whitelistType = whitelist.item(n).getNodeName();
            HashSet<Integer> projs = new HashSet<Integer>();
            NodeList projectsList = whitelist.item(n).getChildNodes();
            for (int i = 0; i < projectsList.getLength(); ++i) {
                Node node = projectsList.item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().equals(PROJECT_TAG)) continue;
                ProjectWhitelist.parseProjectTag(node, projs);
            }
            projsWhitelisted.put(WhitelistType.valueOf(whitelistType), projs);
        }
        projectsWhitelisted.set(projsWhitelisted);
    }

    private static void parseProjectTag(Node node, Set<Integer> projects) {
        NamedNodeMap projectAttrMap = node.getAttributes();
        Node projectIdAttr = projectAttrMap.getNamedItem(PROJECTID_ATTR);
        if (projectIdAttr == null) {
            throw new RuntimeException("Error loading project. The 'projectid' attribute doesn't exist");
        }
        String projectId = projectIdAttr.getNodeValue();
        projects.add(Integer.parseInt(projectId));
    }

    public static boolean isProjectWhitelisted(int project, WhitelistType whitelistType) {
        Set<Integer> projs;
        Map<WhitelistType, Set<Integer>> projsWhitelisted = projectsWhitelisted.get();
        if (projsWhitelisted != null && (projs = projsWhitelisted.get((Object)whitelistType)) != null) {
            return projs.contains(project);
        }
        return false;
    }

    public static enum WhitelistType {
        MemoryCheck,
        NumJobPerFlow;

    }
}

