/*
 * Decompiled with CFR 0.152.
 */
package azkaban.metric;

import azkaban.metric.IMetric;
import azkaban.metric.IMetricEmitter;
import azkaban.metric.MetricException;
import azkaban.utils.Props;

public class GangliaMetricEmitter
implements IMetricEmitter {
    private static final String GANGLIA_METRIC_REPORTER_PATH = "azkaban.metric.ganglia.path";
    private final String gmetricPath;

    public GangliaMetricEmitter(Props azkProps) {
        this.gmetricPath = azkProps.get((Object)GANGLIA_METRIC_REPORTER_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildCommand(IMetric<?> metric) {
        String cmd = null;
        IMetric<?> iMetric = metric;
        synchronized (iMetric) {
            cmd = String.format("%s -t %s -n %s -v %s", this.gmetricPath, metric.getValueType(), metric.getName(), metric.getValue().toString());
        }
        return cmd;
    }

    @Override
    public void reportMetric(IMetric<?> metric) throws MetricException {
        block4: {
            String gangliaCommand = this.buildCommand(metric);
            if (gangliaCommand != null) {
                try {
                    Process emission = Runtime.getRuntime().exec(gangliaCommand);
                    int exitCode = emission.waitFor();
                    if (exitCode != 0) {
                        throw new MetricException("Failed to report metric using gmetric");
                    }
                    break block4;
                }
                catch (Exception e) {
                    throw new MetricException("Failed to report metric using gmetric");
                }
            }
            throw new MetricException("Failed to build ganglia Command");
        }
    }

    @Override
    public void purgeAllData() throws MetricException {
    }
}

