/*
 * Decompiled with CFR 0.152.
 */
package azkaban.flow;

import azkaban.flow.Node;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Edge {
    private final String sourceId;
    private final String targetId;
    private Node source;
    private Node target;
    private String error;
    private String guideType;
    private List<Point2D> guideValues;

    public Edge(String fromId, String toId) {
        this.sourceId = fromId;
        this.targetId = toId;
    }

    public Edge(Edge clone) {
        this.sourceId = clone.getSourceId();
        this.targetId = clone.getTargetId();
        this.error = clone.getError();
    }

    public static Edge fromObject(Object obj) {
        HashMap edgeObj = (HashMap)obj;
        String source = (String)edgeObj.get("source");
        String target = (String)edgeObj.get("target");
        String error = (String)edgeObj.get("error");
        Edge edge = new Edge(source, target);
        edge.setError(error);
        if (edgeObj.containsKey("guides")) {
            Map guideMap = (Map)edgeObj.get("guides");
            List values = (List)guideMap.get("values");
            String type = (String)guideMap.get("type");
            ArrayList<Point2D> valuePoints = new ArrayList<Point2D>();
            for (Object pointObj : values) {
                Map point = (Map)pointObj;
                Double x = (Double)point.get("x");
                Double y = (Double)point.get("y");
                valuePoints.add(new Point2D.Double(x, y));
            }
            edge.setGuides(type, valuePoints);
        }
        return edge;
    }

    public String getId() {
        return this.getSourceId() + ">>" + this.getTargetId();
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public Node getSource() {
        return this.source;
    }

    public void setSource(Node source) {
        this.source = source;
    }

    public Node getTarget() {
        return this.target;
    }

    public void setTarget(Node target) {
        this.target = target;
    }

    public String getGuideType() {
        return this.guideType;
    }

    public List<Point2D> getGuideValues() {
        return this.guideValues;
    }

    public void setGuides(String type, List<Point2D> values) {
        this.guideType = type;
        this.guideValues = values;
    }

    public Object toObject() {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("source", this.getSourceId());
        obj.put("target", this.getTargetId());
        if (this.hasError()) {
            obj.put("error", this.error);
        }
        if (this.guideValues != null) {
            HashMap<String, Object> lineGuidesObj = new HashMap<String, Object>();
            lineGuidesObj.put("type", this.guideType);
            ArrayList guides = new ArrayList();
            for (Point2D point : this.guideValues) {
                HashMap<String, Double> pointObj = new HashMap<String, Double>();
                pointObj.put("x", point.getX());
                pointObj.put("y", point.getY());
                guides.add(pointObj);
            }
            lineGuidesObj.put("values", guides);
            obj.put("guides", lineGuidesObj);
        }
        return obj;
    }
}

