/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor.selector;

import org.apache.log4j.Logger;

public final class FactorFilter<T, V> {
    private static final Logger logger = Logger.getLogger(FactorFilter.class);
    private final String factorName;
    private final Filter<T, V> filter;

    private FactorFilter(String factorName, Filter<T, V> filter) {
        this.factorName = factorName;
        this.filter = filter;
    }

    public static <T, V> FactorFilter<T, V> create(String factorName, Filter<T, V> filter) {
        if (null == factorName || factorName.length() == 0 || null == filter) {
            logger.error((Object)"failed to create instance of FactorFilter, at least one of the input paramters are invalid");
            return null;
        }
        return new FactorFilter<T, V>(factorName, filter);
    }

    public String getFactorName() {
        return this.factorName;
    }

    public boolean filterTarget(T filteringTarget, V referencingObject) {
        return this.filter.filterTarget(filteringTarget, referencingObject);
    }

    public static interface Filter<T, V> {
        public boolean filterTarget(T var1, V var2);
    }
}

