/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.db.DatabaseOperator;
import azkaban.executor.ExecutorManagerException;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.log4j.Logger;

@Singleton
public class NumExecutionsDao {
    private static final Logger logger = Logger.getLogger(NumExecutionsDao.class);
    private final DatabaseOperator dbOperator;

    @Inject
    public NumExecutionsDao(DatabaseOperator dbOperator) {
        this.dbOperator = dbOperator;
    }

    public int fetchNumExecutableFlows() throws ExecutorManagerException {
        try {
            return (Integer)this.dbOperator.query("SELECT COUNT(1) FROM execution_flows", (ResultSetHandler)new IntHandler(), new Object[0]);
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching num executions", e);
        }
    }

    public int fetchNumExecutableFlows(int projectId, String flowId) throws ExecutorManagerException {
        IntHandler intHandler = new IntHandler();
        try {
            return (Integer)this.dbOperator.query("SELECT COUNT(1) FROM execution_flows WHERE project_id=? AND flow_id=?", (ResultSetHandler)intHandler, new Object[]{projectId, flowId});
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching num executions", e);
        }
    }

    public int fetchNumExecutableNodes(int projectId, String jobId) throws ExecutorManagerException {
        IntHandler intHandler = new IntHandler();
        try {
            return (Integer)this.dbOperator.query("SELECT COUNT(1) FROM execution_jobs WHERE project_id=? AND job_id=?", (ResultSetHandler)intHandler, new Object[]{projectId, jobId});
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching num executions", e);
        }
    }

    private static class IntHandler
    implements ResultSetHandler<Integer> {
        private static final String NUM_EXECUTIONS = "SELECT COUNT(1) FROM execution_flows";
        private static final String NUM_FLOW_EXECUTIONS = "SELECT COUNT(1) FROM execution_flows WHERE project_id=? AND flow_id=?";
        private static final String NUM_JOB_EXECUTIONS = "SELECT COUNT(1) FROM execution_jobs WHERE project_id=? AND job_id=?";

        private IntHandler() {
        }

        public Integer handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return 0;
            }
            return rs.getInt(1);
        }
    }
}

