/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.db.DatabaseOperator;
import azkaban.executor.Executor;
import azkaban.executor.ExecutorManagerException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.log4j.Logger;

@Singleton
public class ExecutorDao {
    private static final Logger logger = Logger.getLogger(ExecutorDao.class);
    private final DatabaseOperator dbOperator;

    @Inject
    public ExecutorDao(DatabaseOperator dbOperator) {
        this.dbOperator = dbOperator;
    }

    List<Executor> fetchAllExecutors() throws ExecutorManagerException {
        try {
            return (List)this.dbOperator.query(FetchExecutorHandler.FETCH_ALL_EXECUTORS, (ResultSetHandler)new FetchExecutorHandler(), new Object[0]);
        }
        catch (Exception e) {
            throw new ExecutorManagerException("Error fetching executors", e);
        }
    }

    List<Executor> fetchActiveExecutors() throws ExecutorManagerException {
        try {
            return (List)this.dbOperator.query(FetchExecutorHandler.FETCH_ACTIVE_EXECUTORS, (ResultSetHandler)new FetchExecutorHandler(), new Object[0]);
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching active executors", e);
        }
    }

    public Executor fetchExecutor(String host, int port) throws ExecutorManagerException {
        try {
            List executors = (List)this.dbOperator.query(FetchExecutorHandler.FETCH_EXECUTOR_BY_HOST_PORT, (ResultSetHandler)new FetchExecutorHandler(), new Object[]{host, port});
            if (executors.isEmpty()) {
                return null;
            }
            return (Executor)executors.get(0);
        }
        catch (SQLException e) {
            throw new ExecutorManagerException(String.format("Error fetching executor %s:%d", host, port), e);
        }
    }

    public Executor fetchExecutor(int executorId) throws ExecutorManagerException {
        try {
            List executors = (List)this.dbOperator.query(FetchExecutorHandler.FETCH_EXECUTOR_BY_ID, (ResultSetHandler)new FetchExecutorHandler(), new Object[]{executorId});
            if (executors.isEmpty()) {
                return null;
            }
            return (Executor)executors.get(0);
        }
        catch (Exception e) {
            throw new ExecutorManagerException(String.format("Error fetching executor with id: %d", executorId), e);
        }
    }

    Executor fetchExecutorByExecutionId(int executionId) throws ExecutorManagerException {
        FetchExecutorHandler executorHandler = new FetchExecutorHandler();
        try {
            List executors = (List)this.dbOperator.query(FetchExecutorHandler.FETCH_EXECUTION_EXECUTOR, (ResultSetHandler)executorHandler, new Object[]{executionId});
            if (executors.size() > 0) {
                return (Executor)executors.get(0);
            }
            return null;
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching executor for exec_id : " + executionId, e);
        }
    }

    Executor addExecutor(String host, int port) throws ExecutorManagerException {
        if (this.fetchExecutor(host, port) != null) {
            throw new ExecutorManagerException(String.format("Executor %s:%d already exist", host, port));
        }
        this.addExecutorHelper(host, port);
        return this.fetchExecutor(host, port);
    }

    private void addExecutorHelper(String host, int port) throws ExecutorManagerException {
        String INSERT = "INSERT INTO executors (host, port) values (?,?)";
        try {
            this.dbOperator.update("INSERT INTO executors (host, port) values (?,?)", new Object[]{host, port});
        }
        catch (SQLException e) {
            throw new ExecutorManagerException(String.format("Error adding %s:%d ", host, port), e);
        }
    }

    public void updateExecutor(Executor executor) throws ExecutorManagerException {
        String UPDATE = "UPDATE executors SET host=?, port=?, active=? where id=?";
        try {
            int rows = this.dbOperator.update("UPDATE executors SET host=?, port=?, active=? where id=?", new Object[]{executor.getHost(), executor.getPort(), executor.isActive(), executor.getId()});
            if (rows == 0) {
                throw new ExecutorManagerException("No executor with id :" + executor.getId());
            }
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error inactivating executor " + executor.getId(), e);
        }
    }

    void removeExecutor(String host, int port) throws ExecutorManagerException {
        String DELETE = "DELETE FROM executors WHERE host=? AND port=?";
        try {
            int rows = this.dbOperator.update("DELETE FROM executors WHERE host=? AND port=?", new Object[]{host, port});
            if (rows == 0) {
                throw new ExecutorManagerException("No executor with host, port :(" + host + "," + port + ")");
            }
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error removing executor with host, port : (" + host + "," + port + ")", e);
        }
    }

    public static class FetchExecutorHandler
    implements ResultSetHandler<List<Executor>> {
        static String FETCH_ALL_EXECUTORS = "SELECT id, host, port, active FROM executors";
        static String FETCH_ACTIVE_EXECUTORS = "SELECT id, host, port, active FROM executors where active=true";
        static String FETCH_EXECUTOR_BY_ID = "SELECT id, host, port, active FROM executors where id=?";
        static String FETCH_EXECUTOR_BY_HOST_PORT = "SELECT id, host, port, active FROM executors where host=? AND port=?";
        static String FETCH_EXECUTION_EXECUTOR = "SELECT ex.id, ex.host, ex.port, ex.active FROM  executors ex INNER JOIN execution_flows ef on ex.id = ef.executor_id  where exec_id=?";

        public List<Executor> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<Executor> executors = new ArrayList<Executor>();
            do {
                int id = rs.getInt(1);
                String host = rs.getString(2);
                int port = rs.getInt(3);
                boolean active = rs.getBoolean(4);
                Executor executor = new Executor(id, host, port, active);
                executors.add(executor);
            } while (rs.next());
            return executors;
        }
    }
}

