/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.AlerterHolder;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutionControllerUtils;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.ExecutorManagerUpdaterStage;
import azkaban.executor.RunningExecutions;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.log4j.Logger;

public class ExecutionFinalizer {
    private static final Logger logger = Logger.getLogger(ExecutionFinalizer.class);
    private final ExecutorLoader executorLoader;
    private final ExecutorManagerUpdaterStage updaterStage;
    private final AlerterHolder alerterHolder;
    private final RunningExecutions runningExecutions;

    @Inject
    public ExecutionFinalizer(ExecutorLoader executorLoader, ExecutorManagerUpdaterStage updaterStage, AlerterHolder alerterHolder, RunningExecutions runningExecutions) {
        this.executorLoader = executorLoader;
        this.updaterStage = updaterStage;
        this.alerterHolder = alerterHolder;
        this.runningExecutions = runningExecutions;
    }

    public void finalizeFlow(ExecutableFlow flow, String reason, @Nullable Throwable originalError) {
        int execId = flow.getExecutionId();
        boolean alertUser = true;
        this.updaterStage.set("finalizing flow " + execId);
        try {
            ExecutableFlow dsFlow;
            if (ExecutionControllerUtils.isFinished(flow)) {
                dsFlow = flow;
            } else {
                this.updaterStage.set("finalizing flow " + execId + " loading from db");
                dsFlow = this.executorLoader.fetchExecutableFlow(execId);
                if (!ExecutionControllerUtils.isFinished(dsFlow)) {
                    this.updaterStage.set("finalizing flow " + execId + " failing the flow");
                    ExecutionControllerUtils.failEverything(dsFlow);
                    this.executorLoader.updateExecutableFlow(dsFlow);
                }
            }
            this.updaterStage.set("finalizing flow " + execId + " deleting active reference");
            if (flow.getEndTime() == -1L) {
                flow.setEndTime(System.currentTimeMillis());
                this.executorLoader.updateExecutableFlow(dsFlow);
            }
            this.executorLoader.removeActiveExecutableReference(execId);
            this.updaterStage.set("finalizing flow " + execId + " cleaning from memory");
            this.runningExecutions.get().remove(execId);
        }
        catch (ExecutorManagerException e) {
            alertUser = false;
            logger.error((Object)e);
        }
        this.updaterStage.set("finalizing flow " + execId + " alerting and emailing");
        if (alertUser) {
            ExecutionControllerUtils.alertUserOnFlowFinished(flow, this.alerterHolder, ExecutionControllerUtils.getFinalizeFlowReasons(reason, originalError));
        }
    }
}

