/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.alert.Alerter;
import azkaban.executor.AlerterHolder;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import java.util.LinkedList;
import javax.annotation.Nullable;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionControllerUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionControllerUtils.class);

    public static void finalizeFlow(ExecutorLoader executorLoader, AlerterHolder alerterHolder, ExecutableFlow flow, String reason, @Nullable Throwable originalError) {
        boolean alertUser = true;
        try {
            ExecutableFlow dsFlow;
            if (ExecutionControllerUtils.isFinished(flow)) {
                dsFlow = flow;
            } else {
                dsFlow = executorLoader.fetchExecutableFlow(flow.getExecutionId());
                if (!ExecutionControllerUtils.isFinished(dsFlow)) {
                    ExecutionControllerUtils.failEverything(dsFlow);
                    executorLoader.updateExecutableFlow(dsFlow);
                }
            }
            if (flow.getEndTime() == -1L) {
                flow.setEndTime(System.currentTimeMillis());
                executorLoader.updateExecutableFlow(dsFlow);
            }
        }
        catch (ExecutorManagerException e) {
            alertUser = false;
            logger.error("Failed to finalize flow " + flow.getExecutionId() + ", do not alert user.", (Throwable)e);
        }
        if (alertUser) {
            ExecutionControllerUtils.alertUserOnFlowFinished(flow, alerterHolder, ExecutionControllerUtils.getFinalizeFlowReasons(reason, originalError));
        }
    }

    public static void alertUserOnFlowFinished(ExecutableFlow flow, AlerterHolder alerterHolder, String[] extraReasons) {
        ExecutionOptions options = flow.getExecutionOptions();
        Alerter mailAlerter = alerterHolder.get("email");
        if (flow.getStatus() != Status.SUCCEEDED) {
            if (options.getFailureEmails() != null && !options.getFailureEmails().isEmpty()) {
                try {
                    mailAlerter.alertOnError(flow, extraReasons);
                }
                catch (Exception e) {
                    logger.error("Failed to alert on error for execution " + flow.getExecutionId(), (Throwable)e);
                }
            }
            if (options.getFlowParameters().containsKey("alert.type")) {
                String alertType = options.getFlowParameters().get("alert.type");
                Alerter alerter = alerterHolder.get(alertType);
                if (alerter != null) {
                    try {
                        alerter.alertOnError(flow, extraReasons);
                    }
                    catch (Exception e) {
                        logger.error("Failed to alert on error by " + alertType + " for execution " + flow.getExecutionId(), (Throwable)e);
                    }
                } else {
                    logger.error("Alerter type " + alertType + " doesn't exist. Failed to alert.");
                }
            }
        } else {
            if (options.getSuccessEmails() != null && !options.getSuccessEmails().isEmpty()) {
                try {
                    mailAlerter.alertOnSuccess(flow);
                }
                catch (Exception e) {
                    logger.error("Failed to alert on success for execution " + flow.getExecutionId(), (Throwable)e);
                }
            }
            if (options.getFlowParameters().containsKey("alert.type")) {
                String alertType = options.getFlowParameters().get("alert.type");
                Alerter alerter = alerterHolder.get(alertType);
                if (alerter != null) {
                    try {
                        alerter.alertOnSuccess(flow);
                    }
                    catch (Exception e) {
                        logger.error("Failed to alert on success by " + alertType + " for execution " + flow.getExecutionId(), (Throwable)e);
                    }
                } else {
                    logger.error("Alerter type " + alertType + " doesn't exist. Failed to alert.");
                }
            }
        }
    }

    public static void alertUserOnFirstError(ExecutableFlow flow, AlerterHolder alerterHolder) {
        ExecutionOptions options = flow.getExecutionOptions();
        if (options.getNotifyOnFirstFailure()) {
            logger.info("Alert on first error of execution " + flow.getExecutionId());
            Alerter mailAlerter = alerterHolder.get("email");
            try {
                mailAlerter.alertOnFirstError(flow);
            }
            catch (Exception e) {
                logger.error("Failed to send first error email." + e.getMessage(), (Throwable)e);
            }
            if (options.getFlowParameters().containsKey("alert.type")) {
                String alertType = options.getFlowParameters().get("alert.type");
                Alerter alerter = alerterHolder.get(alertType);
                if (alerter != null) {
                    try {
                        alerter.alertOnFirstError(flow);
                    }
                    catch (Exception e) {
                        logger.error("Failed to alert by " + alertType, (Throwable)e);
                    }
                } else {
                    logger.error("Alerter type " + alertType + " doesn't exist. Failed to alert.");
                }
            }
        }
    }

    public static String[] getFinalizeFlowReasons(String reason, Throwable originalError) {
        LinkedList<String> reasons = new LinkedList<String>();
        reasons.add(reason);
        if (originalError != null) {
            reasons.add(ExceptionUtils.getStackTrace((Throwable)originalError));
        }
        return reasons.toArray(new String[reasons.size()]);
    }

    public static void failEverything(ExecutableFlow exFlow) {
        long time = System.currentTimeMillis();
        block4: for (ExecutableNode node : exFlow.getExecutableNodes()) {
            switch (node.getStatus()) {
                case SUCCEEDED: 
                case FAILED: 
                case KILLED: 
                case SKIPPED: 
                case DISABLED: {
                    continue block4;
                }
                case READY: {
                    node.setStatus(Status.KILLING);
                    break;
                }
                default: {
                    node.setStatus(Status.FAILED);
                }
            }
            if (node.getStartTime() == -1L) {
                node.setStartTime(time);
            }
            if (node.getEndTime() != -1L) continue;
            node.setEndTime(time);
        }
        if (exFlow.getEndTime() == -1L) {
            exFlow.setEndTime(time);
        }
        exFlow.setStatus(Status.FAILED);
    }

    public static boolean isFinished(ExecutableFlow flow) {
        switch (flow.getStatus()) {
            case SUCCEEDED: 
            case FAILED: 
            case KILLED: {
                return true;
            }
        }
        return false;
    }
}

