/*
 * Decompiled with CFR 0.152.
 */
package azkaban.database;

import azkaban.database.AzkabanDatabaseSetup;
import azkaban.server.AzkabanServer;
import azkaban.utils.Props;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.log4j.Logger;

public class AzkabanDatabaseUpdater {
    private static final Logger logger = Logger.getLogger(AzkabanDatabaseUpdater.class);

    public static void main(String[] args) throws Exception {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec scriptDirectory = parser.acceptsAll(Arrays.asList("s", "script"), "Directory of update scripts.").withRequiredArg().describedAs("script").ofType(String.class);
        OptionSpecBuilder updateOption = parser.acceptsAll(Arrays.asList("u", "update"), "Will update if necessary");
        Props props = AzkabanServer.loadProps(args, parser);
        if (props == null) {
            logger.error((Object)"Properties not found. Need it to connect to the db.");
            logger.error((Object)"Exiting...");
            return;
        }
        OptionSet options = parser.parse(args);
        boolean updateDB = false;
        if (options.has((OptionSpec)updateOption)) {
            updateDB = true;
        } else {
            logger.info((Object)"Running DatabaseUpdater in test mode");
        }
        String scriptDir = "sql";
        if (options.has((OptionSpec)scriptDirectory)) {
            scriptDir = (String)options.valueOf((OptionSpec)scriptDirectory);
        }
        AzkabanDatabaseUpdater.runDatabaseUpdater(props, scriptDir, updateDB);
    }

    public static void runDatabaseUpdater(Props props, String sqlDir, boolean updateDB) throws IOException, SQLException {
        logger.info((Object)("Use scripting directory " + sqlDir));
        if (updateDB) {
            logger.info((Object)"Will auto update any changes.");
        } else {
            logger.info((Object)"Running DatabaseUpdater in test mode. Use -u to update");
        }
        AzkabanDatabaseSetup setup = new AzkabanDatabaseSetup(props);
        setup.loadTableInfo();
        if (!setup.needsUpdating()) {
            logger.info((Object)"Everything looks up to date.");
            return;
        }
        logger.info((Object)"Need to update the db.");
        setup.printUpgradePlan();
        if (updateDB) {
            logger.info((Object)"Updating DB");
            setup.updateDatabase(true, true);
        }
    }
}

