/*
 * Decompiled with CFR 0.152.
 */
package azkaban;

import azkaban.spi.AzkabanException;
import azkaban.storage.HdfsAuth;
import azkaban.utils.Props;
import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(HadoopModule.class);
    private final Props props;

    HadoopModule(Props props) {
        this.props = props;
    }

    @Inject
    @Provides
    @Singleton
    public Configuration createHadoopConfiguration() {
        String hadoopConfDirPath = Objects.requireNonNull(this.props.get((Object)"hadoop.conf.dir.path"));
        File hadoopConfDir = new File(Objects.requireNonNull(hadoopConfDirPath));
        Preconditions.checkArgument((hadoopConfDir.exists() && hadoopConfDir.isDirectory() ? 1 : 0) != 0);
        Configuration hadoopConf = new Configuration(false);
        hadoopConf.addResource(new Path(hadoopConfDirPath, "core-site.xml"));
        hadoopConf.addResource(new Path(hadoopConfDirPath, "hdfs-site.xml"));
        hadoopConf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
        return hadoopConf;
    }

    @Inject
    @Provides
    @Singleton
    public FileSystem createHadoopFileSystem(Configuration hadoopConf, HdfsAuth auth) {
        try {
            auth.authorize();
            return FileSystem.get((Configuration)hadoopConf);
        }
        catch (IOException e) {
            log.error("Unable to initialize HDFS", (Throwable)e);
            throw new AzkabanException((Throwable)e);
        }
    }

    protected void configure() {
    }
}

