/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migrationx.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class Config {
    private static ThreadLocal<Config> THREAD_LOCAL = new ThreadLocal();
    private boolean skipUnSupportType = false;
    private boolean transformContinueWithError = false;
    private boolean specContinueWithError = false;
    private List<String> skipTypes = new ArrayList<String>();
    private List<String> skipTaskCodes = new ArrayList<String>();
    private List<String> tempTaskTypes = new ArrayList<String>();
    private boolean zipSpec = true;
    private List<String> filterTasks = new ArrayList<String>();
    private ProcessFilter processFilter;
    private String basePath;
    private List<Replaced> replaceMapping;
    private String source;
    private String version;
    private boolean includeGlobalParam = true;
    private String scriptDir;
    private Map<String, String> postHandlers;

    public static Config get() {
        return THREAD_LOCAL.get();
    }

    public static void init(Config config) {
        THREAD_LOCAL.set(config);
        if (config.getReplaceMapping() != null) {
            for (Replaced replaced : config.getReplaceMapping()) {
                replaced.setParsedPattern(Pattern.compile(replaced.getPattern()));
            }
        }
    }

    public static void init() {
        THREAD_LOCAL.set(new Config());
    }

    public boolean isVersion32() {
        return this.version.startsWith("3.2");
    }

    public boolean isSkipUnSupportType() {
        return this.skipUnSupportType;
    }

    public boolean isTransformContinueWithError() {
        return this.transformContinueWithError;
    }

    public boolean isSpecContinueWithError() {
        return this.specContinueWithError;
    }

    public List<String> getSkipTypes() {
        return this.skipTypes;
    }

    public List<String> getSkipTaskCodes() {
        return this.skipTaskCodes;
    }

    public List<String> getTempTaskTypes() {
        return this.tempTaskTypes;
    }

    public boolean isZipSpec() {
        return this.zipSpec;
    }

    public List<String> getFilterTasks() {
        return this.filterTasks;
    }

    public ProcessFilter getProcessFilter() {
        return this.processFilter;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public List<Replaced> getReplaceMapping() {
        return this.replaceMapping;
    }

    public String getSource() {
        return this.source;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isIncludeGlobalParam() {
        return this.includeGlobalParam;
    }

    public String getScriptDir() {
        return this.scriptDir;
    }

    public Map<String, String> getPostHandlers() {
        return this.postHandlers;
    }

    public void setSkipUnSupportType(boolean skipUnSupportType) {
        this.skipUnSupportType = skipUnSupportType;
    }

    public void setTransformContinueWithError(boolean transformContinueWithError) {
        this.transformContinueWithError = transformContinueWithError;
    }

    public void setSpecContinueWithError(boolean specContinueWithError) {
        this.specContinueWithError = specContinueWithError;
    }

    public void setSkipTypes(List<String> skipTypes) {
        this.skipTypes = skipTypes;
    }

    public void setSkipTaskCodes(List<String> skipTaskCodes) {
        this.skipTaskCodes = skipTaskCodes;
    }

    public void setTempTaskTypes(List<String> tempTaskTypes) {
        this.tempTaskTypes = tempTaskTypes;
    }

    public void setZipSpec(boolean zipSpec) {
        this.zipSpec = zipSpec;
    }

    public void setFilterTasks(List<String> filterTasks) {
        this.filterTasks = filterTasks;
    }

    public void setProcessFilter(ProcessFilter processFilter) {
        this.processFilter = processFilter;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setReplaceMapping(List<Replaced> replaceMapping) {
        this.replaceMapping = replaceMapping;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setIncludeGlobalParam(boolean includeGlobalParam) {
        this.includeGlobalParam = includeGlobalParam;
    }

    public void setScriptDir(String scriptDir) {
        this.scriptDir = scriptDir;
    }

    public void setPostHandlers(Map<String, String> postHandlers) {
        this.postHandlers = postHandlers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSkipUnSupportType() != other.isSkipUnSupportType()) {
            return false;
        }
        if (this.isTransformContinueWithError() != other.isTransformContinueWithError()) {
            return false;
        }
        if (this.isSpecContinueWithError() != other.isSpecContinueWithError()) {
            return false;
        }
        if (this.isZipSpec() != other.isZipSpec()) {
            return false;
        }
        if (this.isIncludeGlobalParam() != other.isIncludeGlobalParam()) {
            return false;
        }
        List<String> this$skipTypes = this.getSkipTypes();
        List<String> other$skipTypes = other.getSkipTypes();
        if (this$skipTypes == null ? other$skipTypes != null : !((Object)this$skipTypes).equals(other$skipTypes)) {
            return false;
        }
        List<String> this$skipTaskCodes = this.getSkipTaskCodes();
        List<String> other$skipTaskCodes = other.getSkipTaskCodes();
        if (this$skipTaskCodes == null ? other$skipTaskCodes != null : !((Object)this$skipTaskCodes).equals(other$skipTaskCodes)) {
            return false;
        }
        List<String> this$tempTaskTypes = this.getTempTaskTypes();
        List<String> other$tempTaskTypes = other.getTempTaskTypes();
        if (this$tempTaskTypes == null ? other$tempTaskTypes != null : !((Object)this$tempTaskTypes).equals(other$tempTaskTypes)) {
            return false;
        }
        List<String> this$filterTasks = this.getFilterTasks();
        List<String> other$filterTasks = other.getFilterTasks();
        if (this$filterTasks == null ? other$filterTasks != null : !((Object)this$filterTasks).equals(other$filterTasks)) {
            return false;
        }
        ProcessFilter this$processFilter = this.getProcessFilter();
        ProcessFilter other$processFilter = other.getProcessFilter();
        if (this$processFilter == null ? other$processFilter != null : !((Object)this$processFilter).equals(other$processFilter)) {
            return false;
        }
        String this$basePath = this.getBasePath();
        String other$basePath = other.getBasePath();
        if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
            return false;
        }
        List<Replaced> this$replaceMapping = this.getReplaceMapping();
        List<Replaced> other$replaceMapping = other.getReplaceMapping();
        if (this$replaceMapping == null ? other$replaceMapping != null : !((Object)this$replaceMapping).equals(other$replaceMapping)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$scriptDir = this.getScriptDir();
        String other$scriptDir = other.getScriptDir();
        if (this$scriptDir == null ? other$scriptDir != null : !this$scriptDir.equals(other$scriptDir)) {
            return false;
        }
        Map<String, String> this$postHandlers = this.getPostHandlers();
        Map<String, String> other$postHandlers = other.getPostHandlers();
        return !(this$postHandlers == null ? other$postHandlers != null : !((Object)this$postHandlers).equals(other$postHandlers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Config;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSkipUnSupportType() ? 79 : 97);
        result = result * 59 + (this.isTransformContinueWithError() ? 79 : 97);
        result = result * 59 + (this.isSpecContinueWithError() ? 79 : 97);
        result = result * 59 + (this.isZipSpec() ? 79 : 97);
        result = result * 59 + (this.isIncludeGlobalParam() ? 79 : 97);
        List<String> $skipTypes = this.getSkipTypes();
        result = result * 59 + ($skipTypes == null ? 43 : ((Object)$skipTypes).hashCode());
        List<String> $skipTaskCodes = this.getSkipTaskCodes();
        result = result * 59 + ($skipTaskCodes == null ? 43 : ((Object)$skipTaskCodes).hashCode());
        List<String> $tempTaskTypes = this.getTempTaskTypes();
        result = result * 59 + ($tempTaskTypes == null ? 43 : ((Object)$tempTaskTypes).hashCode());
        List<String> $filterTasks = this.getFilterTasks();
        result = result * 59 + ($filterTasks == null ? 43 : ((Object)$filterTasks).hashCode());
        ProcessFilter $processFilter = this.getProcessFilter();
        result = result * 59 + ($processFilter == null ? 43 : ((Object)$processFilter).hashCode());
        String $basePath = this.getBasePath();
        result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
        List<Replaced> $replaceMapping = this.getReplaceMapping();
        result = result * 59 + ($replaceMapping == null ? 43 : ((Object)$replaceMapping).hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $scriptDir = this.getScriptDir();
        result = result * 59 + ($scriptDir == null ? 43 : $scriptDir.hashCode());
        Map<String, String> $postHandlers = this.getPostHandlers();
        result = result * 59 + ($postHandlers == null ? 43 : ((Object)$postHandlers).hashCode());
        return result;
    }

    public String toString() {
        return "Config(skipUnSupportType=" + this.isSkipUnSupportType() + ", transformContinueWithError=" + this.isTransformContinueWithError() + ", specContinueWithError=" + this.isSpecContinueWithError() + ", skipTypes=" + this.getSkipTypes() + ", skipTaskCodes=" + this.getSkipTaskCodes() + ", tempTaskTypes=" + this.getTempTaskTypes() + ", zipSpec=" + this.isZipSpec() + ", filterTasks=" + this.getFilterTasks() + ", processFilter=" + this.getProcessFilter() + ", basePath=" + this.getBasePath() + ", replaceMapping=" + this.getReplaceMapping() + ", source=" + this.getSource() + ", version=" + this.getVersion() + ", includeGlobalParam=" + this.isIncludeGlobalParam() + ", scriptDir=" + this.getScriptDir() + ", postHandlers=" + this.getPostHandlers() + ")";
    }

    public static class Replaced {
        private String taskType;
        private String desc;
        private String pattern;
        private Pattern parsedPattern;
        private String target;
        private String param;

        public String getTaskType() {
            return this.taskType;
        }

        public String getDesc() {
            return this.desc;
        }

        public String getPattern() {
            return this.pattern;
        }

        public Pattern getParsedPattern() {
            return this.parsedPattern;
        }

        public String getTarget() {
            return this.target;
        }

        public String getParam() {
            return this.param;
        }

        public void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public void setParsedPattern(Pattern parsedPattern) {
            this.parsedPattern = parsedPattern;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public void setParam(String param) {
            this.param = param;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Replaced)) {
                return false;
            }
            Replaced other = (Replaced)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$taskType = this.getTaskType();
            String other$taskType = other.getTaskType();
            if (this$taskType == null ? other$taskType != null : !this$taskType.equals(other$taskType)) {
                return false;
            }
            String this$desc = this.getDesc();
            String other$desc = other.getDesc();
            if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
                return false;
            }
            String this$pattern = this.getPattern();
            String other$pattern = other.getPattern();
            if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
                return false;
            }
            Pattern this$parsedPattern = this.getParsedPattern();
            Pattern other$parsedPattern = other.getParsedPattern();
            if (this$parsedPattern == null ? other$parsedPattern != null : !this$parsedPattern.equals(other$parsedPattern)) {
                return false;
            }
            String this$target = this.getTarget();
            String other$target = other.getTarget();
            if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                return false;
            }
            String this$param = this.getParam();
            String other$param = other.getParam();
            return !(this$param == null ? other$param != null : !this$param.equals(other$param));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Replaced;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $taskType = this.getTaskType();
            result = result * 59 + ($taskType == null ? 43 : $taskType.hashCode());
            String $desc = this.getDesc();
            result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
            String $pattern = this.getPattern();
            result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
            Pattern $parsedPattern = this.getParsedPattern();
            result = result * 59 + ($parsedPattern == null ? 43 : $parsedPattern.hashCode());
            String $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            String $param = this.getParam();
            result = result * 59 + ($param == null ? 43 : $param.hashCode());
            return result;
        }

        public String toString() {
            return "Config.Replaced(taskType=" + this.getTaskType() + ", desc=" + this.getDesc() + ", pattern=" + this.getPattern() + ", parsedPattern=" + this.getParsedPattern() + ", target=" + this.getTarget() + ", param=" + this.getParam() + ")";
        }
    }

    public static class ProcessFilter {
        private String releaseState;
        private boolean includeSubProcess;

        public String getReleaseState() {
            return this.releaseState;
        }

        public boolean isIncludeSubProcess() {
            return this.includeSubProcess;
        }

        public void setReleaseState(String releaseState) {
            this.releaseState = releaseState;
        }

        public void setIncludeSubProcess(boolean includeSubProcess) {
            this.includeSubProcess = includeSubProcess;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcessFilter)) {
                return false;
            }
            ProcessFilter other = (ProcessFilter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isIncludeSubProcess() != other.isIncludeSubProcess()) {
                return false;
            }
            String this$releaseState = this.getReleaseState();
            String other$releaseState = other.getReleaseState();
            return !(this$releaseState == null ? other$releaseState != null : !this$releaseState.equals(other$releaseState));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProcessFilter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isIncludeSubProcess() ? 79 : 97);
            String $releaseState = this.getReleaseState();
            result = result * 59 + ($releaseState == null ? 43 : $releaseState.hashCode());
            return result;
        }

        public String toString() {
            return "Config.ProcessFilter(releaseState=" + this.getReleaseState() + ", includeSubProcess=" + this.isIncludeSubProcess() + ")";
        }
    }
}

