/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migrationx.common.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.dozer.DozerBeanMapper;

public class BeanUtils {
    private static final DozerBeanMapper DOZER_BEAN_MAPPER = new DozerBeanMapper();

    public static <T> T deepCopy(Object obj, Class<T> clazz) {
        if (obj == null || clazz == null) {
            return null;
        }
        if (!clazz.isInstance(obj)) {
            throw new IllegalArgumentException("obj is not instance of clazz");
        }
        return (T)DOZER_BEAN_MAPPER.map(obj, clazz);
    }

    private BeanUtils() {
    }

    public static void copyProperties(Object src, Object dest) {
        try {
            org.apache.commons.beanutils.BeanUtils.copyProperties((Object)dest, (Object)src);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyProperties(Object src, Object dest, String ... ignoreProperties) {
        try {
            BeanUtils.copyPropertiesWithIgnore(dest, src, ignoreProperties);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void copyPropertiesWithIgnore(Object dest, Object orig, String ... ignoreProperties) throws IllegalAccessException, InvocationTargetException {
        PropertyDescriptor[] origDescriptors;
        List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
        for (PropertyDescriptor origDescriptor : origDescriptors = PropertyUtils.getPropertyDescriptors((Object)orig)) {
            String name = origDescriptor.getName();
            if ("class".equals(name) || ignoreList != null && ignoreList.contains(name) || !PropertyUtils.isReadable((Object)orig, (String)name) || !PropertyUtils.isWriteable((Object)dest, (String)name)) continue;
            try {
                Object value = PropertyUtils.getSimpleProperty((Object)orig, (String)name);
                org.apache.commons.beanutils.BeanUtils.setProperty((Object)dest, (String)name, (Object)value);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }
}

