/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.credprovider.plugin.core.nacos.injector;

import com.alibaba.nacos.plugin.auth.api.LoginIdentityContext;
import com.alibaba.nacos.plugin.auth.api.RequestResource;
import com.aliyun.akless.credprovider.plugin.core.nacos.NacosAuthPluginServiceImpl;
import com.aliyun.akless.credprovider.plugin.core.nacos.injector.AbstractResourceInjector;
import com.aliyun.akless.credprovider.plugin.core.nacos.utils.SignUtil;
import com.aliyun.credentials.models.CredentialModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamingResourceInjector
extends AbstractResourceInjector {
    private static Logger log = LoggerFactory.getLogger(NacosAuthPluginServiceImpl.class);
    private static final String SIGNATURE_FILED = "signature";
    private static final String DATA_FILED = "data";
    private static final String AK_FILED = "ak";
    private static final String SECURITY_TOKEN_HEADER = "Spas-SecurityToken";
    private static final String SERVICE_INFO_SPLITER = "@@";

    @Override
    public void doInject(RequestResource resource, CredentialModel credential, LoginIdentityContext result) {
        try {
            result.setParameter(SECURITY_TOKEN_HEADER, credential.getSecurityToken());
            String signData = this.getSignData(this.getGroupedServiceName(resource));
            String signature = SignUtil.sign(signData, credential.getAccessKeySecret());
            result.setParameter(SIGNATURE_FILED, signature);
            result.setParameter(DATA_FILED, signData);
            result.setParameter(AK_FILED, credential.getAccessKeyId());
        }
        catch (Exception e) {
            log.error("inject ak/sk failed.", (Throwable)e);
        }
    }

    private String getGroupedServiceName(RequestResource resource) {
        if (resource.getResource().contains(SERVICE_INFO_SPLITER) || StringUtils.isBlank((CharSequence)resource.getGroup())) {
            return resource.getResource();
        }
        return resource.getGroup() + SERVICE_INFO_SPLITER + resource.getResource();
    }

    private String getSignData(String serviceName) {
        return StringUtils.isNotEmpty((CharSequence)serviceName) ? System.currentTimeMillis() + SERVICE_INFO_SPLITER + serviceName : String.valueOf(System.currentTimeMillis());
    }
}

