/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.credprovider.plugin.core.nacos.injector;

import com.alibaba.nacos.plugin.auth.api.LoginIdentityContext;
import com.alibaba.nacos.plugin.auth.api.RequestResource;
import com.aliyun.akless.credprovider.plugin.core.nacos.injector.AbstractResourceInjector;
import com.aliyun.akless.credprovider.plugin.core.nacos.utils.SpasAdapter;
import com.aliyun.credentials.models.CredentialModel;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ConfigResourceInjector
extends AbstractResourceInjector {
    private static final String ACCESS_KEY_HEADER = "Spas-AccessKey";
    private static final String SECURITY_TOKEN_HEADER = "Spas-SecurityToken";
    private static final String DEFAULT_RESOURCE = "";

    @Override
    public void doInject(RequestResource resource, CredentialModel credential, LoginIdentityContext result) {
        result.setParameter(SECURITY_TOKEN_HEADER, credential.getSecurityToken());
        result.setParameter(ACCESS_KEY_HEADER, credential.getAccessKeyId());
        Map<String, String> signHeaders = SpasAdapter.getSignHeaders(this.getResource(resource.getNamespace(), resource.getGroup()), credential.getAccessKeySecret());
        result.setParameters(signHeaders);
    }

    private String getResource(String tenant, String group) {
        if (StringUtils.isNotBlank((CharSequence)tenant) && StringUtils.isNotBlank((CharSequence)group)) {
            return tenant + "+" + group;
        }
        if (StringUtils.isNotBlank((CharSequence)group)) {
            return group;
        }
        if (StringUtils.isNotBlank((CharSequence)tenant)) {
            return tenant;
        }
        return DEFAULT_RESOURCE;
    }
}

