/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.credprovider.plugin.core.credmgr;

import com.aliyun.akless.credprovider.plugin.common.Constants;
import com.aliyun.akless.credprovider.plugin.common.cred.AklessCredentials;
import com.aliyun.akless.credprovider.plugin.common.enums.BackupRegionMap;
import com.aliyun.akless.credprovider.plugin.common.enums.NetworkEnvMode;
import com.aliyun.akless.credprovider.plugin.common.environment.AklessEnv;
import com.aliyun.akless.credprovider.plugin.common.error.CredProviderCode;
import com.aliyun.akless.credprovider.plugin.common.error.CredProviderException;
import com.aliyun.akless.credprovider.plugin.common.log.EventLogCode;
import com.aliyun.akless.credprovider.plugin.common.log.EventLogMessageKeys;
import com.aliyun.akless.credprovider.plugin.common.log.EventLogger;
import com.aliyun.akless.credprovider.plugin.common.sts.AssumeRoleWithOIDCRequest;
import com.aliyun.akless.credprovider.plugin.common.sts.AssumeRoleWithOIDCResponse;
import com.aliyun.akless.credprovider.plugin.common.utils.IDTokenUtils;
import com.aliyun.akless.credprovider.plugin.common.utils.NetAccessUtils;
import com.aliyun.akless.credprovider.plugin.common.utils.OidcProviderArnUtils;
import com.aliyun.akless.credprovider.plugin.common.utils.StackTraceUtils;
import com.aliyun.akless.credprovider.plugin.core.CredentialProviderConfig;
import com.aliyun.akless.credprovider.plugin.core.credmgr.CredentialManager;
import com.aliyun.akless.credprovider.plugin.core.credmgr.IDTokenCredentialManager;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.regions.ProductDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDTokenStsCredentialManager
implements CredentialManager {
    private String ramRoleArn;
    private String ramRoleArnAliUid;
    private IAcsClient client;
    private AklessCredentials lastCredential;
    private volatile AklessCredentials credentials;
    private String primaryRamEndpoint = null;
    private String backupRamEndpoint;
    private String primaryRamApiVersion;
    private String backupRamApiVersion;
    private Logger log = LoggerFactory.getLogger(IDTokenStsCredentialManager.class);
    private Map<String, Object> messageLog = new HashMap<String, Object>();
    private Map<String, String> credentialsProviderInfo = new HashMap<String, String>();
    private Long stsTokenDurationSeconds = Constants.STSTOKEN_DURATION_SECONDS;
    private final Lock refreshLock = new ReentrantLock();
    private long lastTimeAccessRam = 0L;
    private Throwable lastError;
    private String[] errOutErrorCode = new String[]{"EntityNotExist.Role", "EntityNotExist.User", "InvalidParameter.DurationSeconds", "InvalidParameter.PolicyGrammar", "InvalidParameter.PolicySize", "InvalidParameter.RoleArn", "InvalidParameter.ContentType", "InvalidParameter.ExternalId", "InvalidParameter.RoleSessionName", "InvalidParameter.SerialNumber", "InvalidParameter.TokenCode", "AuthenticationFail.ApiUsername", "AuthenticationFail.ApiPassword", "ErrMalformedIdToken"};
    private String[] tryBackupRamErrorCode = new String[]{"SDK.ServerUnreachable", "SDK.RequestTryOrRetryFailed", "SDK.ReadTimeout", "SDK.UnsupportedEncodingException", "SDK.InterruptedException", "InternalError"};

    public IDTokenStsCredentialManager(CredentialProviderConfig config, String source) {
        this.ramRoleArn = config.getRamRoleArn();
        this.ramRoleArnAliUid = this.ramRoleArn.split(":")[3];
        this.messageLog.put(EventLogMessageKeys.IsFirstRefresh.getValue(), true);
        this.credentialsProviderInfo.put("CredentialsProviderId", this.ramRoleArn + ":" + source + ":" + Long.toHexString(UUID.randomUUID().getMostSignificantBits()));
        this.credentialsProviderInfo.put(EventLogMessageKeys.Source.getValue(), source);
        this.credentialsProviderInfo.put("RamRoleArn", this.ramRoleArn);
        this.resetTraceId();
        if (config.getStsTokenDurationSeconds() != null) {
            this.stsTokenDurationSeconds = config.getStsTokenDurationSeconds();
        }
        DefaultProfile profile = DefaultProfile.getProfile((String)AklessEnv.getRegionId(), (String)"", (String)"");
        this.client = new DefaultAcsClient((IClientProfile)profile);
        if (AklessEnv.isInVPC()) {
            String[] endpoints = new String[]{"sts-vpc-inner.%s.aliyuncs.com", "sts-2-vpc-inner.%s.aliyuncs.com"};
            this.primaryRamEndpoint = NetAccessUtils.getAvailableEndpointWithRegionId(endpoints);
            this.backupRamEndpoint = String.format("sts.%s.aliyuncs.com", BackupRegionMap.getBackupRegion(AklessEnv.getRegionId()));
            this.primaryRamApiVersion = "2018-05-20";
            this.backupRamApiVersion = "2015-04-01";
        } else if (AklessEnv.isInOXS()) {
            this.primaryRamEndpoint = String.format("sts-inner.%s.aliyuncs.com", AklessEnv.getRegionId());
            this.backupRamEndpoint = String.format("sts-inner.%s.aliyuncs.com", BackupRegionMap.getBackupRegion(AklessEnv.getRegionId()));
            this.backupRamApiVersion = "2018-05-20";
            this.primaryRamApiVersion = "2018-05-20";
        } else if (AklessEnv.isInTanneiProduction() || AklessEnv.getNetworkEnv() == NetworkEnvMode.ALIYUN_TEST) {
            this.primaryRamEndpoint = String.format("sts-share.%s.aliyuncs.com", AklessEnv.getRegionId());
            this.backupRamEndpoint = String.format("sts-share.%s.aliyuncs.com", BackupRegionMap.getBackupRegion(AklessEnv.getRegionId()));
            this.backupRamApiVersion = "2018-05-20";
            this.primaryRamApiVersion = "2018-05-20";
        } else if (AklessEnv.getNetworkEnv() == NetworkEnvMode.IDPT_VPC) {
            this.primaryRamEndpoint = this.backupRamEndpoint = String.format("sts-vpc.%s.%scs.com", AklessEnv.getRegionId(), AklessEnv.getBaseDomain());
            this.backupRamApiVersion = "2015-04-01";
            this.primaryRamApiVersion = "2015-04-01";
        } else if (AklessEnv.getNetworkEnv() == NetworkEnvMode.IDPT_OXS) {
            this.primaryRamEndpoint = this.backupRamEndpoint = String.format("sts-intranet.%s.%scs.com", AklessEnv.getRegionId(), AklessEnv.getBaseDomain());
            this.backupRamApiVersion = "2018-05-20";
            this.primaryRamApiVersion = "2018-05-20";
        } else {
            this.primaryRamEndpoint = "sts-share.cn-hangzhou.aliyuncs.com";
            this.backupRamEndpoint = "sts-share.cn-shanghai.aliyuncs.com";
            this.backupRamApiVersion = "2015-04-01";
            this.primaryRamApiVersion = "2015-04-01";
        }
        this.messageLog.put(EventLogMessageKeys.RamEndpoint.getValue(), this.primaryRamEndpoint);
        this.messageLog.put(EventLogMessageKeys.BackupRamEndpoint.getValue(), this.backupRamEndpoint);
    }

    public void resetTraceId() {
        this.credentialsProviderInfo.put(EventLogMessageKeys.TraceId.getValue(), UUID.randomUUID().toString());
    }

    private void assumeRoleGeneralLogInfo() {
        if (this.lastCredential != null) {
            this.messageLog.put(EventLogMessageKeys.LastCredentialExpireAt.getValue(), this.lastCredential.getExpiration());
            this.messageLog.put(EventLogMessageKeys.LastCredentialIssueAt.getValue(), this.lastCredential.getIssueAt());
            this.messageLog.put(EventLogMessageKeys.LastCredentialAccessKeyID.getValue(), this.lastCredential.getAccessKeyId());
        }
        if (this.credentials != null) {
            this.messageLog.put(EventLogMessageKeys.CurrentCredentialExpireAt.getValue(), this.credentials.getExpiration());
            this.messageLog.put(EventLogMessageKeys.CurrentCredentialIssueAt.getValue(), this.credentials.getIssueAt());
            this.messageLog.put(EventLogMessageKeys.CurrentCredentialAccessKeyID.getValue(), this.credentials.getAccessKeyId());
        }
    }

    private boolean reEnrollIDTokenAndRetry(ClientException e) {
        this.log.error("Failed to call assumeRoleWithOIDC, errCode: [{}], errMsg: [{}]", (Object)e.getErrCode(), (Object)e.getErrMsg());
        if (e.getErrCode().startsWith("AuthenticationFail") || "NoPermission".equals(e.getErrCode())) {
            this.log.info("try to re enroll IdToken");
            return true;
        }
        return false;
    }

    private boolean shouldErrorOut(ClientException e) {
        if (e != null) {
            for (String str : this.errOutErrorCode) {
                if (!str.equals(e.getErrCode())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean shouldBackOff(ClientException e) {
        if (e != null && e.getErrCode() != null) {
            return e.getErrCode().startsWith("Throttling");
        }
        return false;
    }

    private boolean shouldTryBackupRegion(ClientException e) {
        if (e != null) {
            for (String str : this.tryBackupRamErrorCode) {
                if (!str.equals(e.getErrCode())) continue;
                return true;
            }
        }
        return false;
    }

    private Pair<AssumeRoleWithOIDCResponse, ClientException> internalAssumeRoleWithOIDC(String idToken, String ramEndpoint, String ramApiVersion) {
        String exceptionMsg = null;
        Long timeStart = null;
        ClientException e = null;
        Integer httpStatusCode = null;
        boolean retry = true;
        for (int i = 0; i < 3 && retry; ++i) {
            try {
                String oidcProviderArn = OidcProviderArnUtils.getOidcProviderArn(idToken, this.ramRoleArnAliUid);
                this.messageLog.put(EventLogMessageKeys.EffectiveRamEndpoint.getValue(), ramEndpoint);
                this.messageLog.put(EventLogMessageKeys.RamEndpoint.getValue(), ramEndpoint);
                this.messageLog.put(EventLogMessageKeys.OIDCProviderArn.getValue(), oidcProviderArn);
                this.messageLog.put(EventLogMessageKeys.DurationSeconds.getValue(), this.stsTokenDurationSeconds);
                this.messageLog.put(EventLogMessageKeys.IdTokenJTI.getValue(), IDTokenUtils.getTokenJti(idToken));
                this.messageLog.put(EventLogMessageKeys.IdTokenRemainTime.getValue(), IDTokenUtils.getRemainValidTimeMills(idToken));
                this.messageLog.put(EventLogMessageKeys.IdTokenValidTime.getValue(), IDTokenUtils.getValidTimeMills(idToken));
                AssumeRoleWithOIDCRequest request = new AssumeRoleWithOIDCRequest();
                request.setProductDomain(new ProductDomain("Sts", ramEndpoint));
                request.setVersion(ramApiVersion);
                request.setOIDCProviderArn(oidcProviderArn);
                request.setRoleArn(this.ramRoleArn);
                request.setOIDCToken(idToken);
                request.setRoleSessionName("akless.credprovider");
                request.setDurationSeconds(this.stsTokenDurationSeconds);
                request.setReadTimeout(1500);
                request.setConnectTimeout(1000);
                timeStart = System.currentTimeMillis();
                AssumeRoleWithOIDCResponse response = (AssumeRoleWithOIDCResponse)this.client.getAcsResponse((AcsRequest)request, false, 0);
                this.messageLog.put(EventLogMessageKeys.RamCostTimeMs.getValue(), System.currentTimeMillis() - timeStart);
                httpStatusCode = 200;
                return new ImmutablePair((Object)response, null);
            }
            catch (Exception ex) {
                this.messageLog.put(EventLogMessageKeys.RamCostTimeMs.getValue(), timeStart != null ? Long.valueOf(System.currentTimeMillis() - timeStart) : null);
                httpStatusCode = ex instanceof ServerException ? 400 : 500;
                e = ex instanceof CredProviderException ? new ClientException(((CredProviderException)ex).getCode(), ((CredProviderException)ex).getMsg()) : (ex instanceof ClientException ? (ClientException)ex : new ClientException(ex.getClass().getSimpleName(), ex.getMessage()));
                this.assumeRoleGeneralLogInfo();
                this.messageLog.put(EventLogMessageKeys.RamHttpStatus.getValue(), httpStatusCode);
                this.messageLog.put(EventLogMessageKeys.RequestID.getValue(), e.getRequestId());
                this.messageLog.put(EventLogMessageKeys.RamErrorCode.getValue(), e.getErrCode());
                this.messageLog.put(EventLogMessageKeys.RamErrorMsg.getValue(), e.getErrMsg());
                exceptionMsg = e.getMessage();
                if (this.shouldBackOff(e)) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                } else if (this.shouldErrorOut(e)) {
                    retry = false;
                } else if (this.reEnrollIDTokenAndRetry(e) && (idToken = IDTokenCredentialManager.refreshIdTokenWithGivenInvalidToken("aliyun-oidc-sts", idToken, this.getCredentialsProviderInfo())) == null) {
                    retry = false;
                }
                this.messageLog.put(EventLogMessageKeys.WillRetry.getValue(), String.format("%s, cnt %d/%d", retry, i, 3));
                this.messageLog.put(EventLogMessageKeys.StackTrace.getValue(), StackTraceUtils.getStackTraceFromException((Throwable)e));
                this.log.warn("Failed to call assumeRoleWithOIDC, errCode: [{}], retry [{}], cnt {}/{}", new Object[]{e.getErrCode(), retry, i, 3});
                EventLogger.send(EventLogCode.StsTokenFailureServer, this.getCredentialsProviderInfo(), this.messageLog);
                continue;
            }
        }
        this.log.error("Failed to call assumeRoleWithOIDC to [{}], msg: [{}]", (Object)ramEndpoint, exceptionMsg);
        return new ImmutablePair(null, e);
    }

    private AssumeRoleWithOIDCResponse assumeRoleWithOIDC(String idToken) throws Exception {
        Pair<AssumeRoleWithOIDCResponse, ClientException> stsResult;
        this.messageLog.put(EventLogMessageKeys.UsingBackupEndpoint.getValue(), false);
        if (this.primaryRamEndpoint == null) {
            String[] endpoints = new String[]{"sts-vpc-inner.%s.aliyuncs.com", "sts-2-vpc-inner.%s.aliyuncs.com"};
            this.primaryRamEndpoint = NetAccessUtils.getAvailableEndpointWithRegionId(endpoints);
            if (this.primaryRamEndpoint != null) {
                this.messageLog.put(EventLogMessageKeys.RamEndpoint.getValue(), this.primaryRamEndpoint);
            }
        }
        if (this.primaryRamEndpoint != null) {
            stsResult = this.internalAssumeRoleWithOIDC(idToken, this.primaryRamEndpoint, this.primaryRamApiVersion);
            if (stsResult.getKey() != null) {
                this.messageLog.put(EventLogMessageKeys.EffectiveRamEndpoint.getValue(), this.primaryRamEndpoint);
                return (AssumeRoleWithOIDCResponse)((Object)stsResult.getKey());
            }
            if (!this.shouldTryBackupRegion((ClientException)stsResult.getValue())) {
                throw new CredProviderException(CredProviderCode.ErrCredentialGen, "Failed to access primary RAM endpoint: " + (stsResult.getValue() != null ? ((ClientException)stsResult.getValue()).getMessage() : ""), (Throwable)stsResult.getValue());
            }
        }
        this.log.warn("Trying backup RAM endpoint [{} -> {}]", (Object)this.primaryRamEndpoint, (Object)this.backupRamEndpoint);
        this.messageLog.put(EventLogMessageKeys.EffectiveRamEndpoint.getValue(), this.backupRamEndpoint);
        this.messageLog.put(EventLogMessageKeys.UsingBackupEndpoint.getValue(), true);
        EventLogger.send(EventLogCode.StsTokenFailureUsingBackupEndpoint, this.getCredentialsProviderInfo(), this.messageLog);
        stsResult = this.internalAssumeRoleWithOIDC(idToken, this.backupRamEndpoint, this.backupRamApiVersion);
        if (stsResult.getKey() != null) {
            return (AssumeRoleWithOIDCResponse)((Object)stsResult.getKey());
        }
        throw new CredProviderException(CredProviderCode.ErrCredentialGen, "Failed to access primary and backup RAM endpoint: " + (stsResult.getValue() != null ? ((ClientException)stsResult.getValue()).getMessage() : ""), (Throwable)stsResult.getValue());
    }

    protected void finalize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshCredentials() {
        long startTime = System.currentTimeMillis();
        try {
            String idToken = IDTokenCredentialManager.getIdToken("aliyun-oidc-sts", this.getCredentialsProviderInfo());
            AssumeRoleWithOIDCResponse resp = this.assumeRoleWithOIDC(idToken);
            AklessCredentials tmpCredentials = new AklessCredentials(resp.getCredentials().getAccessKeyId(), resp.getCredentials().getAccessKeySecret(), resp.getCredentials().getSecurityToken(), resp.getCredentials().getExpiration());
            if (this.credentials != null) {
                this.messageLog.put(EventLogMessageKeys.IsFirstRefresh.getValue(), false);
            }
            this.lastCredential = this.credentials;
            this.credentials = tmpCredentials;
            this.messageLog.put(EventLogMessageKeys.RequestID.getValue(), resp.getRequestId());
            this.assumeRoleGeneralLogInfo();
            this.messageLog.put(EventLogMessageKeys.RamHttpStatus.getValue(), 200);
            this.log.info("Akless CredProvider SDK Successfully get credential for role {}, credential AK: {}, expiration: {}", new Object[]{this.ramRoleArn, this.credentials.getAccessKeyId(), this.credentials.getExpiration()});
            this.lastError = null;
            this.messageLog.remove(EventLogMessageKeys.StackTrace.getValue());
        }
        catch (Throwable e) {
            this.log.error("Failed to generate AklessCredentials: ", e);
            this.messageLog.put(EventLogMessageKeys.StackTrace.getValue(), StackTraceUtils.getStackTraceFromException(e));
            this.lastError = e;
        }
        finally {
            EventLogger.send(EventLogCode.CredProviderSummary, this.getCredentialsProviderInfo(), this.getMessageLog());
            long diff = System.currentTimeMillis() - startTime;
            if (diff > 200L) {
                HashMap<String, Object> secondLevelLog = new HashMap<String, Object>();
                secondLevelLog.put(EventLogMessageKeys.CredentialsProvisionTime.getValue(), diff);
                secondLevelLog.put(EventLogMessageKeys.IsFirstRefresh.getValue(), this.messageLog.get(EventLogMessageKeys.IsFirstRefresh.getValue()));
                EventLogger.send(EventLogCode.CredentialsProvision, this.getCredentialsProviderInfo(), secondLevelLog);
            }
        }
    }

    @Override
    public AklessCredentials getCredentials() {
        if (this.credentials == null || this.credentials.needsRefresh()) {
            try {
                this.refreshLock.lock();
                if (!(this.credentials != null && !this.credentials.needsRefresh() || this.lastTimeAccessRam != 0L && System.currentTimeMillis() - this.lastTimeAccessRam <= 60000L)) {
                    this.lastTimeAccessRam = System.currentTimeMillis();
                    this.refreshCredentials();
                }
            }
            finally {
                this.refreshLock.unlock();
            }
        }
        return this.credentials;
    }

    public String getPrimaryRamEndpoint() {
        return this.primaryRamEndpoint;
    }

    public String getBackupRamEndpoint() {
        return this.backupRamEndpoint;
    }

    public Map<String, Object> getMessageLog() {
        return this.messageLog;
    }

    public Map<String, String> getCredentialsProviderInfo() {
        return this.credentialsProviderInfo;
    }

    public Long getStsTokenDurationSeconds() {
        return this.stsTokenDurationSeconds;
    }

    @Override
    public Throwable getLastError() {
        return this.lastError;
    }
}

