/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.credprovider.plugin.core.credmgr;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.akless.credprovider.plugin.common.cred.AklessCredentials;
import com.aliyun.akless.credprovider.plugin.common.log.EventLogCode;
import com.aliyun.akless.credprovider.plugin.common.log.EventLogMessageKeys;
import com.aliyun.akless.credprovider.plugin.common.log.EventLogger;
import com.aliyun.akless.credprovider.plugin.core.credmgr.IDTokenSecretCredentialManager;
import com.aliyun.kms20160120.models.GetSecretValueResponse;
import java.util.HashMap;
import java.util.Map;

public class IDTokenAKCredentialManager
extends IDTokenSecretCredentialManager {
    public IDTokenAKCredentialManager(String secretName) throws Exception {
        super(secretName);
    }

    @Override
    public void refreshCredentials() throws Exception {
        long startTime = System.currentTimeMillis();
        GetSecretValueResponse response = this.getSecretValue();
        Map secret = (Map)JSONObject.parse((String)response.getBody().secretData);
        if (!secret.containsKey("AccessKeyId") || !secret.containsKey("AccessKeySecret")) {
            throw new RuntimeException("Failed to parse secret " + response.getBody().secretData + " for request" + response.getBody().requestId);
        }
        this.credentials = new AklessCredentials((String)secret.get("AccessKeyId"), (String)secret.get("AccessKeySecret"), "", "2023-09-12T08:14:25Z");
        this.log.info("Succeed in getting credential {} with secret {}", (Object)this.credentials.getAccessKeyId(), (Object)this.secretName);
        HashMap<String, Object> logData = new HashMap<String, Object>();
        logData.put(EventLogMessageKeys.RequestID.getValue(), response.getBody().getRequestId());
        logData.put(EventLogMessageKeys.AccessKeyId.getValue(), this.credentials.getAccessKeyId());
        logData.put(EventLogMessageKeys.CredentialsProvisionTime.getValue(), System.currentTimeMillis() - startTime);
        EventLogger.send(EventLogCode.InnerKmsCredProvider, this.secretInfoLog, logData);
    }
}

