/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.credprovider.plugin.core.credmgr;

import com.aliyun.akless.credprovider.plugin.common.Constants;
import com.aliyun.akless.credprovider.plugin.common.cred.AklessCredentials;
import com.aliyun.akless.credprovider.plugin.common.enums.BackupRegionMap;
import com.aliyun.akless.credprovider.plugin.common.enums.NetworkEnvMode;
import com.aliyun.akless.credprovider.plugin.common.environment.AklessEnv;
import com.aliyun.akless.credprovider.plugin.common.log.EventLogCode;
import com.aliyun.akless.credprovider.plugin.common.log.EventLogMessageKeys;
import com.aliyun.akless.credprovider.plugin.common.log.EventLogger;
import com.aliyun.akless.credprovider.plugin.common.utils.ExceptionUtils;
import com.aliyun.akless.credprovider.plugin.common.utils.OidcProviderArnUtils;
import com.aliyun.akless.credprovider.plugin.common.utils.StackTraceUtils;
import com.aliyun.akless.credprovider.plugin.core.CredentialProviderConfig;
import com.aliyun.akless.credprovider.plugin.core.credmgr.CredentialManager;
import com.aliyun.akless.credprovider.plugin.core.credmgr.IDTokenAKCredentialManager;
import com.aliyun.sts20150401.Client;
import com.aliyun.sts20150401.models.AssumeRoleRequest;
import com.aliyun.sts20150401.models.AssumeRoleResponse;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AKStsCredentialManager
implements CredentialManager {
    private Logger log = LoggerFactory.getLogger(AKStsCredentialManager.class);
    private Config stsConfig;
    private String ramRoleArn;
    private AklessCredentials lastCredential;
    private volatile AklessCredentials credentials;
    private Long stsTokenDurationSeconds;
    private Map<String, Object> messageLog = new HashMap<String, Object>();
    private Map<String, String> credentialsProviderInfo = new HashMap<String, String>();
    private String primaryRamEndpoint;
    private String backupRamEndpoint;
    private final Lock refreshLock = new ReentrantLock();
    private long lastTimeAccessRam = 0L;
    private Throwable lastError = null;

    public AKStsCredentialManager(CredentialProviderConfig config, String source) throws Exception {
        this.ramRoleArn = config.getRamRoleArn();
        this.messageLog.put(EventLogMessageKeys.IsFirstRefresh.getValue(), true);
        this.credentialsProviderInfo.put("CredentialsProviderId", this.ramRoleArn + ":" + source + ":" + Long.toHexString(UUID.randomUUID().getMostSignificantBits()));
        this.credentialsProviderInfo.put(EventLogMessageKeys.Source.getValue(), source);
        this.credentialsProviderInfo.put("RamRoleArn", this.ramRoleArn);
        this.credentialsProviderInfo.put("AK2STS", "true");
        this.resetTraceId();
        this.stsTokenDurationSeconds = config.getStsTokenDurationSeconds() != null ? config.getStsTokenDurationSeconds() : Constants.STSTOKEN_DURATION_SECONDS;
        IDTokenAKCredentialManager manager = new IDTokenAKCredentialManager(OidcProviderArnUtils.ramRoleArn2SecretName(config.getRamRoleArn()));
        this.stsConfig = new Config().setAccessKeyId(manager.getCredentials().getAccessKeyId()).setAccessKeySecret(manager.getCredentials().getAccessKeySecret()).setConnectTimeout(Integer.valueOf(1000)).setReadTimeout(Integer.valueOf(1500)).setProtocol("https");
        if (AklessEnv.isInVPC()) {
            this.primaryRamEndpoint = String.format("sts-vpc.%s.aliyuncs.com", AklessEnv.getRegionId());
            this.backupRamEndpoint = String.format("sts.%s.aliyuncs.com", BackupRegionMap.getBackupRegion(AklessEnv.getRegionId()));
        } else if (AklessEnv.isInOXS()) {
            this.primaryRamEndpoint = String.format("sts-inner.%s.aliyuncs.com", AklessEnv.getRegionId());
            this.backupRamEndpoint = String.format("sts-inner.%s.aliyuncs.com", BackupRegionMap.getBackupRegion(AklessEnv.getRegionId()));
        } else if (AklessEnv.isInTanneiProduction() || AklessEnv.getNetworkEnv() == NetworkEnvMode.ALIYUN_TEST) {
            this.primaryRamEndpoint = String.format("sts-share.%s.aliyuncs.com", AklessEnv.getRegionId());
            this.backupRamEndpoint = String.format("sts-share.%s.aliyuncs.com", BackupRegionMap.getBackupRegion(AklessEnv.getRegionId()));
        } else if (AklessEnv.getNetworkEnv() == NetworkEnvMode.IDPT_VPC) {
            this.primaryRamEndpoint = this.backupRamEndpoint = String.format("sts-vpc.%s.%scs.com", AklessEnv.getRegionId(), AklessEnv.getBaseDomain());
        } else if (AklessEnv.getNetworkEnv() == NetworkEnvMode.IDPT_OXS) {
            this.primaryRamEndpoint = this.backupRamEndpoint = String.format("sts-intranet.%s.%scs.com", AklessEnv.getRegionId(), AklessEnv.getBaseDomain());
        } else {
            this.primaryRamEndpoint = "sts-share.cn-hangzhou.aliyuncs.com";
            this.backupRamEndpoint = "sts-share.cn-shanghai.aliyuncs.com";
        }
        this.messageLog.put(EventLogMessageKeys.RamEndpoint.getValue(), this.primaryRamEndpoint);
        this.messageLog.put(EventLogMessageKeys.BackupRamEndpoint.getValue(), this.backupRamEndpoint);
    }

    private AssumeRoleResponse assumeRole() throws Exception {
        this.messageLog.put(EventLogMessageKeys.UsingBackupEndpoint.getValue(), false);
        try {
            return this.internalAssumeRole(this.primaryRamEndpoint);
        }
        catch (Exception e) {
            if (!ExceptionUtils.shouldTryBackupEndpoint(e)) {
                throw e;
            }
            this.log.warn("Trying backup RAM endpoint [{} -> {}]", (Object)this.primaryRamEndpoint, (Object)this.backupRamEndpoint);
            this.messageLog.put(EventLogMessageKeys.UsingBackupEndpoint.getValue(), true);
            EventLogger.send(EventLogCode.StsTokenFailureUsingBackupEndpoint, this.getCredentialsProviderInfo(), this.messageLog);
            return this.internalAssumeRole(this.backupRamEndpoint);
        }
    }

    private AssumeRoleResponse internalAssumeRole(String ramEndpoint) throws Exception {
        Long timeStart = null;
        AssumeRoleRequest request = new AssumeRoleRequest();
        request.setRoleArn(this.ramRoleArn);
        request.setRoleSessionName("akless.credprovider");
        request.setDurationSeconds(this.stsTokenDurationSeconds);
        RuntimeOptions options = new RuntimeOptions();
        options.setAutoretry(Boolean.valueOf(false));
        this.stsConfig.setEndpoint(ramEndpoint);
        Client stsClient = new Client(this.stsConfig);
        AssumeRoleResponse response = null;
        for (int i = 0; i < 3; ++i) {
            try {
                timeStart = System.currentTimeMillis();
                response = stsClient.assumeRoleWithOptions(request, options);
                this.messageLog.put(EventLogMessageKeys.RamCostTimeMs.getValue(), System.currentTimeMillis() - timeStart);
                return response;
            }
            catch (Exception e) {
                this.log.error("Failed to call AssumeRole as: ", (Throwable)e);
                if (e instanceof TeaException) {
                    TeaException te = (TeaException)e;
                    this.messageLog.put(EventLogMessageKeys.RamErrorCode.getValue(), te.getCode());
                    this.messageLog.put(EventLogMessageKeys.RamErrorMsg.getValue(), te.getMessage() + te.getData());
                } else {
                    this.messageLog.put(EventLogMessageKeys.RamErrorCode.getValue(), e.getClass().getSimpleName());
                    this.messageLog.put(EventLogMessageKeys.RamErrorMsg.getValue(), e.getMessage());
                }
                this.messageLog.put(EventLogMessageKeys.RamCostTimeMs.getValue(), System.currentTimeMillis() - timeStart);
                EventLogger.send(EventLogCode.StsTokenFailureServer, this.credentialsProviderInfo, this.messageLog);
                if (!this.shouldErrorOut(e) && i != 2) continue;
                throw e;
            }
        }
        throw new RuntimeException("This code path should never be reached");
    }

    private boolean shouldErrorOut(Exception e) {
        return e instanceof TeaException && Arrays.asList(Constants.RAM_ERROR_OUT_CODE).contains(((TeaException)e).getCode());
    }

    public void resetTraceId() {
        this.credentialsProviderInfo.put(EventLogMessageKeys.TraceId.getValue(), UUID.randomUUID().toString());
    }

    private void assumeRoleGeneralLogInfo() {
        if (this.lastCredential != null) {
            this.messageLog.put(EventLogMessageKeys.LastCredentialExpireAt.getValue(), this.lastCredential.getExpiration());
            this.messageLog.put(EventLogMessageKeys.LastCredentialIssueAt.getValue(), this.lastCredential.getIssueAt());
            this.messageLog.put(EventLogMessageKeys.LastCredentialAccessKeyID.getValue(), this.lastCredential.getAccessKeyId());
        }
        if (this.credentials != null) {
            this.messageLog.put(EventLogMessageKeys.CurrentCredentialExpireAt.getValue(), this.credentials.getExpiration());
            this.messageLog.put(EventLogMessageKeys.CurrentCredentialIssueAt.getValue(), this.credentials.getIssueAt());
            this.messageLog.put(EventLogMessageKeys.CurrentCredentialAccessKeyID.getValue(), this.credentials.getAccessKeyId());
        }
    }

    protected void finalize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshCredentials() {
        long startTime = System.currentTimeMillis();
        try {
            AssumeRoleResponse response = this.assumeRole();
            AklessCredentials tmpCredentials = new AklessCredentials(response.getBody().getCredentials().getAccessKeyId(), response.getBody().getCredentials().getAccessKeySecret(), response.getBody().getCredentials().getSecurityToken(), response.getBody().getCredentials().getExpiration());
            if (this.credentials != null) {
                this.messageLog.put(EventLogMessageKeys.IsFirstRefresh.getValue(), false);
            }
            this.lastCredential = this.credentials;
            this.credentials = tmpCredentials;
            this.messageLog.put(EventLogMessageKeys.RequestID.getValue(), response.getBody().getRequestId());
            this.assumeRoleGeneralLogInfo();
            this.messageLog.put(EventLogMessageKeys.RamHttpStatus.getValue(), 200);
            this.log.info("Akless CredProvider SDK Successfully get credential for role {}, credential AK: {}, expiration: {}", new Object[]{this.ramRoleArn, this.credentials.getAccessKeyId(), this.credentials.getExpiration()});
            this.lastError = null;
            this.messageLog.remove(EventLogMessageKeys.StackTrace.getValue());
        }
        catch (Throwable e) {
            this.log.error("Failed to generate AklessCredentials: ", e);
            this.messageLog.put(EventLogMessageKeys.StackTrace.getValue(), StackTraceUtils.getStackTraceFromException(e));
            this.lastError = e;
        }
        finally {
            this.messageLog.put(EventLogMessageKeys.CredentialsProvisionTime.getValue(), System.currentTimeMillis() - startTime);
            EventLogger.send(EventLogCode.CredProviderSummary, this.getCredentialsProviderInfo(), this.getMessageLog());
        }
    }

    @Override
    public AklessCredentials getCredentials() {
        if (this.credentials == null || this.credentials.needsRefresh()) {
            try {
                this.refreshLock.lock();
                if (!(this.credentials != null && !this.credentials.needsRefresh() || this.lastTimeAccessRam != 0L && System.currentTimeMillis() - this.lastTimeAccessRam <= 60000L)) {
                    this.lastTimeAccessRam = System.currentTimeMillis();
                    this.refreshCredentials();
                }
            }
            finally {
                this.refreshLock.unlock();
            }
        }
        return this.credentials;
    }

    public Map<String, Object> getMessageLog() {
        return this.messageLog;
    }

    public Map<String, String> getCredentialsProviderInfo() {
        return this.credentialsProviderInfo;
    }

    public String getPrimaryRamEndpoint() {
        return this.primaryRamEndpoint;
    }

    public String getBackupRamEndpoint() {
        return this.backupRamEndpoint;
    }

    @Override
    public Throwable getLastError() {
        return this.lastError;
    }
}

