/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.credprovider.plugin.common.utils;

import com.aliyun.akless.credprovider.plugin.common.log.EventLogMessageKeys;
import com.aliyun.akless.idprovider.errors.IdpException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class StackTraceUtils {
    private static String getStackTraceStr(StackTraceElement[] stack, int startFrom) {
        ArrayList<StackTraceElement> stackTraces = new ArrayList<StackTraceElement>(20);
        for (int i = startFrom; i < stack.length; ++i) {
            StackTraceElement stackTraceElement = stack[i];
            stackTraces.add(stackTraceElement);
            if (stackTraces.size() >= 20) break;
        }
        return StringUtils.join(stackTraces, (String)"\n\t");
    }

    public static String getStackTrace() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        return StackTraceUtils.getStackTraceStr(stack, 1);
    }

    public static String getStackTraceFromException(Throwable e) {
        if (e instanceof IdpException) {
            return ((IdpException)e).getStackTraces();
        }
        return ExceptionUtils.getStackTrace((Throwable)e);
    }

    public static Map<String, Object> handleExceptionInfo(Throwable e) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(EventLogMessageKeys.RamErrorMsg.getValue(), e.getMessage());
        data.put(EventLogMessageKeys.StackTrace.getValue(), StackTraceUtils.getStackTraceFromException(e));
        data.put(EventLogMessageKeys.RamErrorCode.getValue(), e instanceof IdpException ? "IdpException: " + ((IdpException)e).getCode() : e.getClass().getName());
        return data;
    }
}

