/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.credprovider.plugin.common.utils;

import com.aliyun.akless.credprovider.plugin.common.error.CredProviderCode;
import com.aliyun.akless.credprovider.plugin.common.error.CredProviderException;
import com.aliyun.akless.credprovider.plugin.common.utils.IDTokenUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcProviderArnUtils {
    private static Logger log = LoggerFactory.getLogger(OidcProviderArnUtils.class);
    private static Map<String, String> regexMap = new HashMap<String, String>();

    public static String getOidcProviderArn(String idToken, String aliUid) throws CredProviderException {
        String issuer;
        try {
            issuer = IDTokenUtils.getIssuer(idToken);
        }
        catch (CredProviderException e) {
            throw new CredProviderException(CredProviderCode.ErrMalformedIdToken, String.format("failed to get issuer from idtoken: [%s]", e));
        }
        for (String key : regexMap.keySet()) {
            Pattern pattern = Pattern.compile(key);
            Matcher matcher = pattern.matcher(issuer);
            if (!matcher.find()) continue;
            String regionId = matcher.group(1);
            return String.format(regexMap.get(key), aliUid, regionId);
        }
        throw new CredProviderException(CredProviderCode.ErrMalformedIdToken, String.format("failed to find matching issuer format for [%s]", issuer));
    }

    public static String ramRoleArn2SecretName(String ramRoleArn) {
        String[] parts = ramRoleArn.split(":");
        String aliUid = parts[3];
        parts = ramRoleArn.split("/", 2);
        String roleName = parts[1];
        return "itenant_aliyun:default:cmp-engine:cmp-engine-production:secret/" + aliUid + "-" + roleName;
    }

    static {
        regexMap.put("https://aliyun-app-idp-center-(.*)\\.oss-(.*)\\.aliyuncs\\.com", "acs:ram::%s:oidc-provider/zeus_oidc_provider-center-%s");
        regexMap.put("https://aliyun-app-idp-(.*)\\.oss-(.*)\\.aliyuncs\\.com", "acs:ram::%s:oidc-provider/zeus_oidc_provider-%s");
        regexMap.put("https://aliyun-app-idp-(.*)\\.oss-(.*)\\..*-inner-private\\.com", "acs:ram::%s:oidc-provider/zeus_oidc_provider-%s");
        regexMap.put("https://app-idp-pre-(.*)\\.oss-(.*)\\.aliyuncs.com", "acs:ram::%s:oidc-provider/zeus_oidc_provider-pre-%s");
    }
}

