/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.credprovider.plugin.common.metaservice;

import com.aliyun.akless.credprovider.plugin.common.error.CredProviderCode;
import com.aliyun.akless.credprovider.plugin.common.error.CredProviderException;
import com.aliyun.akless.credprovider.plugin.common.utils.NetAccessUtils;
import java.io.DataInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaService {
    private static Boolean metaServiceAccess = null;
    private static String instanceId = null;
    private static Logger log = LoggerFactory.getLogger(MetaService.class);
    private static String enforceModeToken = null;
    private static Long enforceModeExpiration;
    private static final MetaService instance;
    private static final int HTTP_SUCCESS_CODE = 200;
    private static final int CONNECT_TIMEOUT = 3000;
    private static final int READ_TIMEOUT = 3000;
    private static final int ENFORCE_EXPIRATION_JUDGE = 10000;
    private static final String ENFORCE_EXPIRATION_REQ = "20";
    private static final String ENFORCE_TOKEN_HEADER = "X-aliyun-ecs-metadata-token-ttl-seconds";

    public static boolean hasMetaServiceAccess() {
        return metaServiceAccess != null ? metaServiceAccess : false;
    }

    private static String internalCurlContent(String urlStr, String propertyKey, String propertyValue, String requestMethod) throws Exception {
        URL url = new URL(urlStr);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (requestMethod != null) {
            connection.setRequestMethod(requestMethod);
        }
        connection.setConnectTimeout(3000);
        connection.setReadTimeout(3000);
        if (propertyKey != null && propertyValue != null) {
            connection.setRequestProperty(propertyKey, propertyValue);
        }
        connection.connect();
        Integer httpCode = connection.getResponseCode();
        if (httpCode != 200) {
            throw new CredProviderException(CredProviderCode.ErrMetaServiceResp, String.format("metaserver token http request code %d", httpCode));
        }
        InputStream is = connection.getInputStream();
        DataInputStream dataInputStream = new DataInputStream(is);
        byte[] serverMsg = new byte[connection.getContentLength()];
        dataInputStream.readFully(serverMsg);
        dataInputStream.close();
        is.close();
        return new String(serverMsg, StandardCharsets.UTF_8);
    }

    private static String curlContent(String urlStr) throws CredProviderException {
        if (!MetaService.hasMetaServiceAccess()) {
            return null;
        }
        if (enforceModeExpiration == null || enforceModeExpiration <= System.currentTimeMillis() || enforceModeToken == null) {
            try {
                enforceModeToken = MetaService.internalCurlContent("http://100.100.100.200/latest/api/token", ENFORCE_TOKEN_HEADER, ENFORCE_EXPIRATION_REQ, "PUT");
                enforceModeExpiration = System.currentTimeMillis() + 10000L;
                log.debug("successfully get enforceModeToken");
            }
            catch (Exception e) {
                log.error("Failed to get token for accessing metaserver {}", (Object)e.toString());
            }
        }
        if (StringUtils.isBlank((CharSequence)enforceModeToken)) {
            throw new CredProviderException(CredProviderCode.ErrMetaServiceAccess, "Failed to get valid enforcemode token");
        }
        try {
            String metaServerMsg = MetaService.internalCurlContent(urlStr, "X-aliyun-ecs-metadata-token", enforceModeToken, null);
            log.debug("curlContent {} return {}", (Object)urlStr, (Object)metaServerMsg);
            return metaServerMsg;
        }
        catch (Exception e) {
            enforceModeExpiration = null;
            enforceModeToken = null;
            throw new CredProviderException(CredProviderCode.ErrMetaServiceAccess, String.format("Failed to fetch info from given url %s: %s", urlStr, e.toString()));
        }
    }

    private MetaService() {
        if (metaServiceAccess != null) {
            return;
        }
        metaServiceAccess = NetAccessUtils.checkAccessibility("100.100.100.200");
    }

    public static String fetchInstanceId() throws CredProviderException {
        if (instanceId != null) {
            return instanceId;
        }
        instanceId = MetaService.curlContent("http://100.100.100.200/latest/meta-data/instance-id");
        return instanceId;
    }

    static {
        instance = new MetaService();
    }
}

