/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.credprovider.plugin.common.error;

import com.aliyun.akless.credprovider.plugin.common.error.CredProviderCode;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;

public class CredProviderException
extends Exception {
    private CredProviderCode code;
    private String msg;

    public CredProviderException(CredProviderCode code, String msg) {
        super(msg + "[" + code.getCode() + "]");
        this.code = code;
        this.msg = msg;
    }

    public CredProviderException(CredProviderCode code, String msg, Throwable cause) {
        super(msg + "[" + code.getCode() + "]", cause);
        this.code = code;
        this.msg = msg;
    }

    public CredProviderException(CredProviderCode code) {
        super(code.getCode() + ": " + code.getMsg());
        this.code = code;
        this.msg = null;
    }

    public String getMsg() {
        if (this.msg != null) {
            return this.msg + "[" + this.code.getCode() + "]";
        }
        return this.code.getCode() + ": " + this.code.getMsg();
    }

    public String getCode() {
        return this.code.getCode();
    }

    public static CredProviderException buildCredProviderException(CredProviderCode code, Throwable e) {
        if (e instanceof CredProviderException) {
            return (CredProviderException)e;
        }
        if (e instanceof ServerException) {
            return new CredProviderException(code, ((ServerException)e).getErrMsg(), e);
        }
        if (e instanceof ClientException) {
            return new CredProviderException(code, ((ClientException)e).getErrMsg(), e);
        }
        return new CredProviderException(code, e.toString(), e);
    }
}

