/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.credprovider.plugin.common.environment;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.akless.credprovider.plugin.common.enums.NetworkEnvMode;
import com.aliyun.akless.credprovider.plugin.common.error.CredProviderCode;
import com.aliyun.akless.credprovider.plugin.common.error.CredProviderException;
import com.aliyun.akless.credprovider.plugin.common.log.EventLogCode;
import com.aliyun.akless.credprovider.plugin.common.log.EventLogMessageKeys;
import com.aliyun.akless.credprovider.plugin.common.log.EventLogger;
import com.aliyun.akless.credprovider.plugin.common.metaservice.MetaService;
import com.aliyun.akless.credprovider.plugin.common.utils.NetAccessUtils;
import com.aliyun.akless.credprovider.plugin.common.utils.StackTraceUtils;
import com.aliyun.akless.credprovider.plugin.core.credmgr.IDTokenCredentialManager;
import com.aliyun.akless.idprovider.model.EnvConfig;
import com.aliyun.akless.idprovider.provider.AklessIDTokenProviderFactory;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AklessEnv {
    private static NetworkEnvMode networkEnv;
    private static JSONObject CMDBData;
    private static String regionId;
    private static String appName;
    private static String appGroup;
    private static String appEnv;
    private static String idToken;
    private static String instanceId;
    private static boolean aklessEnvInited;
    private static String cloudType;
    private static String baseDomain;
    private static Logger log;
    public static String AklessEnvString;

    private static String initInstanceId() throws Exception {
        try {
            if (CMDBData == null) {
                throw new RuntimeException("cmdb data not found");
            }
            instanceId = CMDBData.getString("sn");
            if (StringUtils.isBlank((CharSequence)instanceId)) {
                throw new RuntimeException("get empty instance id from cmdb data");
            }
            log.info("AklessEnv get instance ID {} from cmdbdata", (Object)instanceId);
            return instanceId;
        }
        catch (Exception e) {
            log.info("Failed to parse cmdb file since {}, trying other ways", (Object)e.toString());
            try {
                String fileName = "/usr/sbin/staragent_sn";
                instanceId = String.join((CharSequence)"\n", Files.readAllLines(Paths.get(fileName, new String[0]), StandardCharsets.UTF_8));
                if (StringUtils.isBlank((CharSequence)instanceId)) {
                    throw new RuntimeException("get empty instance id from localfile");
                }
                log.info("AklessEnv get instance ID {} from localfile", (Object)instanceId);
                return instanceId;
            }
            catch (Exception e2) {
                log.info("Failed to parse sa file {}, trying other ways", (Object)e2.toString());
                try {
                    if (MetaService.hasMetaServiceAccess()) {
                        String instanceIdTmp = MetaService.fetchInstanceId();
                        if (StringUtils.isBlank((CharSequence)instanceIdTmp)) {
                            throw new RuntimeException("get empty instance id from metaserver");
                        }
                        log.info("AklessEnv get instance ID {} from metaserver", (Object)instanceIdTmp);
                        return instanceIdTmp;
                    }
                }
                catch (Exception e3) {
                    log.info("Failed to fetch instance ID info from metaserver: {}, trying other ways", (Object)e3.toString());
                }
                try {
                    InetAddress localHost = InetAddress.getLocalHost();
                    return localHost.getHostName();
                }
                catch (Exception e4) {
                    log.info("Failed to fetch instance ID info from host name: {}, trying other ways", (Object)e4.toString());
                    throw new CredProviderException(CredProviderCode.ErrRegionIdInit);
                }
            }
        }
    }

    private static NetworkEnvMode initNetworkEnv(String regionId) throws Exception {
        if (NetAccessUtils.checkAccessibility(String.format("app-idp-inner-vpc.%s.aliyuncs.com", regionId)) || NetAccessUtils.checkAccessibility(String.format("app-idp-inner-2-vpc.%s.aliyuncs.com", regionId))) {
            log.debug("check app-idp-inner-vpc access success");
            return NetworkEnvMode.VPC_MODE;
        }
        if (NetAccessUtils.checkAccessibility(String.format("app-idp-inner.%s.aliyuncs.com", regionId))) {
            log.debug("check app-idp-inner access success");
            return NetworkEnvMode.OXS_MODE;
        }
        if (NetAccessUtils.checkAccessibility("cn-hangzhou-share.log.aliyuncs.com")) {
            log.debug("check cn-hangzhou-share.log access success");
            return NetworkEnvMode.OFFICE_MODE;
        }
        throw new CredProviderException(CredProviderCode.ErrNetworkEnvInit);
    }

    private static JSONObject initCMDBData() {
        try {
            String fileName = "/home/staragent/plugins/sap.src/local_data/host_cmdb.data";
            String CMDBData = String.join((CharSequence)"\n", Files.readAllLines(Paths.get(fileName, new String[0]), StandardCharsets.UTF_8));
            return JSON.parseObject((String)CMDBData);
        }
        catch (Exception e) {
            log.info("failed to parse cmdb data: {}", (Object)e.toString());
            return null;
        }
    }

    private static void fillEnvData(Map<String, String> map) {
        map.put("RegionId", regionId);
        map.put("AppName", appName);
        map.put("AppGroup", appGroup);
        map.put("AppEnv", appEnv);
    }

    public static synchronized void initEnv(String regionId, String appName, String appGroup, String appEnv, String bootstrapToken, String idToken) throws Exception {
        if (aklessEnvInited) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)idToken) && StringUtils.isBlank((CharSequence)bootstrapToken)) {
            throw new RuntimeException("Both bootstrapToken and idToken are required");
        }
        long startTime = System.currentTimeMillis();
        HashMap<String, String> aklessEnvMap = new HashMap<String, String>();
        aklessEnvMap.put("CpVersion", "1.10.2");
        aklessEnvMap.put("Language", "Java");
        AklessEnv.regionId = regionId;
        AklessEnv.appName = appName;
        AklessEnv.appGroup = appGroup;
        AklessEnv.appEnv = appEnv;
        AklessEnv.fillEnvData(aklessEnvMap);
        AklessEnvString = JSON.toJSONString(aklessEnvMap);
        try {
            block12: {
                EnvConfig idpEnvConfig = AklessIDTokenProviderFactory.initEnvConfig((String)regionId, (String)appName, (String)appGroup, (String)appEnv, (String)bootstrapToken);
                AklessEnv.regionId = idpEnvConfig.getRegionId();
                AklessEnv.appName = idpEnvConfig.getAppName();
                AklessEnv.appGroup = idpEnvConfig.getAppGroup();
                AklessEnv.appEnv = idpEnvConfig.getAppEnv();
                instanceId = idpEnvConfig.getInstanceId();
                AklessEnv.idToken = idToken;
                cloudType = idpEnvConfig.getCloudType();
                baseDomain = idpEnvConfig.getBaseDomain();
                if (StringUtils.isNotBlank((CharSequence)System.getenv("AKLESS_CP_REGIONID"))) {
                    AklessEnv.regionId = System.getenv("AKLESS_CP_REGIONID");
                }
                String _net = idpEnvConfig.getNetworkType();
                HashSet<String> netEnvSet = new HashSet<String>(Arrays.asList("vpc", "office", "daily", "tannei_production", "oxs", "idpt_outer_oxs", "idpt_outer_vpc"));
                String userInputNetEnv = System.getenv("AKLESS_CP_NETENV");
                if (StringUtils.isNotBlank((CharSequence)userInputNetEnv) && netEnvSet.contains(userInputNetEnv)) {
                    _net = userInputNetEnv;
                }
                if (((networkEnv = "vpc".equals(_net) ? NetworkEnvMode.VPC_MODE : ("office".equals(_net) ? NetworkEnvMode.OFFICE_MODE : ("daily".equals(_net) ? NetworkEnvMode.DAILY_MODE : ("tannei_production".equals(_net) ? NetworkEnvMode.TANNEI_PRODUCTION_MODE : ("idpt_outer_oxs".equals(_net) ? NetworkEnvMode.IDPT_OXS : ("idpt_outer_vpc".equals(_net) ? NetworkEnvMode.IDPT_VPC : ("aliyun_test".equals(_net) ? NetworkEnvMode.ALIYUN_TEST : NetworkEnvMode.OXS_MODE))))))) == NetworkEnvMode.IDPT_OXS || networkEnv == NetworkEnvMode.IDPT_VPC) && StringUtils.isBlank((CharSequence)baseDomain)) {
                    throw new RuntimeException("base domain should not be empty for net env: " + _net + ", idp net env: " + idpEnvConfig.getNetworkType());
                }
                try {
                    IDTokenCredentialManager.setupIdTokenProvider();
                }
                catch (Exception e) {
                    if (!StringUtils.isBlank((CharSequence)idToken) && AklessEnv.shouldOmitIDPException(e)) break block12;
                    throw e;
                }
            }
            aklessEnvMap.put("InstanceId", instanceId);
            aklessEnvMap.put("NetEnv", networkEnv.toString());
            AklessEnv.fillEnvData(aklessEnvMap);
            AklessEnvString = JSON.toJSONString(aklessEnvMap);
            EventLogger.resetEventLogger();
            aklessEnvInited = true;
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put(EventLogMessageKeys.StartupTime.getValue(), System.currentTimeMillis() - startTime);
            EventLogger.send(EventLogCode.CpInitSuccess, null, item);
            log.debug("initEnv get:\ninstanceId: {}\nregionId: {}\nnetworkEnv: {}\nappName: {}\nappGroup: {}\nappEnv: {}\ncpVersion: {}", new Object[]{instanceId, AklessEnv.regionId, networkEnv, AklessEnv.appName, AklessEnv.appGroup, AklessEnv.appEnv, "1.10.2"});
        }
        catch (Throwable e) {
            log.error("failed to initialize environment", e);
            try {
                if (networkEnv == null) {
                    CMDBData = AklessEnv.initCMDBData();
                    instanceId = AklessEnv.initInstanceId();
                    networkEnv = AklessEnv.initNetworkEnv(AklessEnv.regionId);
                }
                EventLogger.resetEventLogger();
                EventLogger.send(EventLogCode.IdpInitFailure, null, StackTraceUtils.handleExceptionInfo(e));
            }
            catch (Exception ec) {
                log.error("try init necessary info failed: ", (Throwable)ec);
            }
            throw e;
        }
    }

    public static boolean isInOXS() {
        return networkEnv == NetworkEnvMode.OXS_MODE;
    }

    public static boolean isInVPC() {
        return networkEnv == NetworkEnvMode.VPC_MODE;
    }

    public static boolean isInOffice() {
        return networkEnv == NetworkEnvMode.OFFICE_MODE;
    }

    public static boolean isInTanneiProduction() {
        return networkEnv == NetworkEnvMode.TANNEI_PRODUCTION_MODE;
    }

    public static boolean isInDaily() {
        return networkEnv == NetworkEnvMode.DAILY_MODE;
    }

    public static boolean isDomestic() {
        return regionId.startsWith("cn-") && regionId != "cn-hongkong";
    }

    public static boolean shouldOmitIDPException(Exception e) {
        return e.getMessage().contains("none of auth server regional and central endpoints are accessible") || e.getMessage().contains("server side error from oidc endpoint") || e.getMessage().contains("common error from oidc endpoint");
    }

    public static NetworkEnvMode getNetworkEnv() {
        return networkEnv;
    }

    public static String getRegionId() {
        return regionId;
    }

    public static String getAppName() {
        return appName;
    }

    public static String getAppGroup() {
        return appGroup;
    }

    public static String getIdToken() {
        return idToken;
    }

    public static boolean isAklessEnvInited() {
        return aklessEnvInited;
    }

    public static String getCloudType() {
        return cloudType;
    }

    public static String getBaseDomain() {
        return baseDomain;
    }

    static {
        aklessEnvInited = false;
        log = LoggerFactory.getLogger(AklessEnv.class);
    }
}

