/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.credprovider.plugin.common.credprovider;

import com.aliyun.akless.credprovider.plugin.common.environment.AklessEnv;
import com.aliyun.akless.credprovider.plugin.common.error.CredProviderCode;
import com.aliyun.akless.credprovider.plugin.common.error.CredProviderException;
import com.aliyun.akless.credprovider.plugin.core.CredentialProviderConfig;
import com.aliyun.akless.credprovider.plugin.core.credmgr.AKStsCredentialManager;
import com.aliyun.akless.credprovider.plugin.core.credmgr.CredentialManager;
import com.aliyun.akless.credprovider.plugin.core.credmgr.IDTokenAKCredentialManager;
import com.aliyun.akless.credprovider.plugin.core.credmgr.IDTokenStsCredentialManager;
import org.apache.commons.lang3.StringUtils;

public class BaseCredentialsProvider {
    protected CredentialManager manager;

    public BaseCredentialsProvider(CredentialProviderConfig config, String source) throws CredProviderException {
        if (StringUtils.isNotBlank((CharSequence)config.getRamRoleArn())) {
            this.manager = new IDTokenStsCredentialManager(config, source);
            if (null == this.manager.getCredentials()) {
                if (StringUtils.isBlank((CharSequence)AklessEnv.getIdToken())) {
                    throw CredProviderException.buildCredProviderException(CredProviderCode.ErrCredentialGen, this.manager.getLastError());
                }
                try {
                    this.manager = new AKStsCredentialManager(config, source);
                }
                catch (Exception e) {
                    throw CredProviderException.buildCredProviderException(CredProviderCode.ErrCredentialGen, e);
                }
                if (null == this.manager.getCredentials()) {
                    throw CredProviderException.buildCredProviderException(CredProviderCode.ErrCredentialGen, this.manager.getLastError());
                }
            }
        } else {
            try {
                this.manager = new IDTokenAKCredentialManager(config.getSecretName());
            }
            catch (Exception e) {
                throw CredProviderException.buildCredProviderException(CredProviderCode.ErrCredentialGen, e);
            }
        }
    }
}

