/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.azkaban.v3.module;

import com.alibaba.cola.dto.Response;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.plugin.Reader;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.workflow.migration.azkaban.v3.handler.Azkabanv3FileHandler;
import com.aliyun.migration.workflow.migration.common.AbstractReader;
import com.aliyun.migration.workflow.migration.common.utils.ZipFileUtil;
import java.io.File;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Azkabanv3Reader
extends AbstractReader {
    private static final Logger log = LoggerFactory.getLogger(Azkabanv3Reader.class);
    private WorkflowProjectPackage workflowProjectPackage;

    public Reader init(TaskContext taskContext) {
        this.setTaskContext(taskContext);
        this.optimalizeReader();
        Datasource scheduleDataSource = taskContext.getReaderDatasource();
        Map scheduleDataSourceProperties = scheduleDataSource.getProperties();
        String packagePath = scheduleDataSourceProperties.getOrDefault("source-file-path", "");
        File dir = new File(packagePath);
        String projectName = scheduleDataSourceProperties.getOrDefault("project_name", dir.getName().endsWith(".zip") ? dir.getName().substring(0, dir.getName().length() - 4) : dir.getName());
        if (dir.exists() && dir.isDirectory()) {
            Azkabanv3FileHandler handler = new Azkabanv3FileHandler(dir, projectName, taskContext);
            this.workflowProjectPackage = handler.getWorkflowProjectPackage();
        } else if (dir.exists() && dir.isFile()) {
            try {
                File decompressDir = ZipFileUtil.decompress((File)dir, (String)dir.getName());
                Azkabanv3FileHandler handler = new Azkabanv3FileHandler(decompressDir, projectName, taskContext);
                this.workflowProjectPackage = handler.getWorkflowProjectPackage();
            }
            catch (Exception e) {
                log.error("decompress azkaban package error: ", (Throwable)e);
            }
        }
        if (this.workflowProjectPackage.getWorkflowProject() == null) {
            this.workflowProjectPackage.setWorkflowProject(new WorkflowProject());
        }
        this.workflowProjectPackage.getWorkflowProject().setName(projectName);
        return this;
    }

    public Response preCheck(Datasource scheduleDataSource) {
        return null;
    }

    public WorkflowProjectPackage read() throws Exception {
        this.taskContext.setWorkflowProjectPackage(this.workflowProjectPackage);
        this.taskContext.setTargetWorkflowProjectPackage(this.workflowProjectPackage);
        return this.workflowProjectPackage;
    }
}

