/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.azkaban.v3.domain.service;

import azkaban.flow.Edge;
import azkaban.flow.Flow;
import azkaban.flow.FlowProps;
import azkaban.flow.Node;
import azkaban.project.DirectoryFlowLoader;
import azkaban.project.DirectoryYamlFlowLoader;
import azkaban.project.FlowLoader;
import azkaban.project.FlowLoaderFactory;
import azkaban.project.Project;
import azkaban.utils.Props;
import com.aliyun.dataworks.common.spec.utils.ReflectUtils;
import com.aliyun.migration.workflow.migration.azkaban.v3.domain.objects.ConfigProperty;
import com.aliyun.migration.workflow.migration.azkaban.v3.domain.objects.FlowJob;
import com.aliyun.migration.workflow.migration.azkaban.v3.domain.objects.Job;
import com.aliyun.migration.workflow.migration.azkaban.v3.domain.objects.JobType;
import com.google.common.base.Joiner;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzkabanPackageParser {
    private static final Logger log = LoggerFactory.getLogger(AzkabanPackageParser.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(AzkabanPackageParser.class);
    public static final String FLOW_NODE_DELIMITER = "@";
    private Map<String, Map<String, Props>> jobProperties = new HashMap<String, Map<String, Props>>();
    private Map<String, FlowSpec> flowJobs = new HashMap<String, FlowSpec>();
    private FlowLoader flowLoader = null;
    private Project project = null;
    private File projectDir = null;

    public Map<String, FlowSpec> getFlowJobs() {
        return this.flowJobs;
    }

    public void parse(File dir, String projectName) throws Exception {
        this.project = new Project(0, projectName);
        this.projectDir = dir;
        FlowLoaderFactory flowLoaderFactory = new FlowLoaderFactory(new Props(null));
        this.flowLoader = flowLoaderFactory.createFlowLoader(dir);
        this.flowLoader.loadProjectFlow(this.project, dir);
        if (this.flowLoader.getErrors() != null && !this.flowLoader.getErrors().isEmpty()) {
            throw new RuntimeException("load project flow error: " + this.flowLoader.getErrors());
        }
        this.convertAzkabanFlows(this.flowLoader, dir);
    }

    private Object convertType(Class<?> fieldType, String value) {
        if (value == null) {
            return null;
        }
        if (fieldType.equals(Integer.class)) {
            return Integer.valueOf(value);
        }
        if (fieldType.equals(String.class)) {
            return value;
        }
        if (fieldType.equals(Long.class)) {
            return Long.valueOf(value);
        }
        throw new RuntimeException("unsupported field type convert: " + fieldType);
    }

    private Object convertType(Field field, ConfigProperty anno, String value) {
        if (value == null) {
            return null;
        }
        Class<?> fieldType = field.getType();
        if (fieldType.equals(List.class)) {
            List<String> parts = Arrays.asList(value.split(anno.delimiter()));
            Type[] actualTypes = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
            if (actualTypes != null && actualTypes.length == 1) {
                Class typeParameter = (Class)actualTypes[0];
                return parts.stream().map(v -> this.convertType(typeParameter, (String)v)).collect(Collectors.toList());
            }
            throw new RuntimeException("unsupported multiple parameter types");
        }
        return this.convertType(fieldType, value);
    }

    private void convertAzkabanFlows(FlowLoader flowLoader, File dir) {
        Map flowMap = MapUtils.emptyIfNull((Map)flowLoader.getFlowMap());
        flowMap.forEach((key, flow) -> {
            File flowFile = new File(dir, flow.getId() + ".flow");
            this.parseFlow(flowLoader, flowFile, (String)key, (Flow)flow);
        });
    }

    private Props getNodeProps(FlowLoader flowLoader, File flowFile, Flow flow, String nodeName) {
        Props defaultProps = new Props(null);
        Node flowNode = CollectionUtils.emptyIfNull((Collection)flow.getNodes()).stream().filter(n -> StringUtils.equals((CharSequence)n.getId(), (CharSequence)nodeName)).findFirst().orElseThrow(() -> new RuntimeException("node: " + nodeName + "\u02dcnot found in flow: " + flow.getId()));
        defaultProps.setSource(flowNode.getPropsSource());
        if (flowLoader instanceof DirectoryYamlFlowLoader) {
            return CollectionUtils.emptyIfNull((Collection)flow.getNodes()).stream().filter(n -> n.getId().equals(nodeName)).map(node -> {
                String nodePropPath = Joiner.on((String)":").join((Object)flow.getId(), (Object)node.getId(), new Object[0]);
                try {
                    Field field = ((DirectoryYamlFlowLoader)flowLoader).getClass().getDeclaredField("jobPropsMap");
                    field.setAccessible(true);
                    Props prop = (Props)MapUtils.emptyIfNull((Map)((Map)field.get(flowLoader))).get(nodePropPath);
                    prop.setSource((String)StringUtils.defaultIfBlank((CharSequence)flowNode.getPropsSource(), (CharSequence)flowNode.getJobSource()));
                    return prop;
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    LOGGER.error("failed to get jobPropsMap from flow loader: {}", flowLoader.getClass());
                    return defaultProps;
                }
            }).filter(Objects::nonNull).findFirst().orElse(defaultProps);
        }
        if (flowLoader instanceof DirectoryFlowLoader) {
            Props prop = Optional.ofNullable((Props)MapUtils.emptyIfNull((Map)((DirectoryFlowLoader)flowLoader).getJobPropsMap()).get(nodeName)).orElse(new Props(defaultProps));
            prop.setSource((String)StringUtils.defaultIfBlank((CharSequence)flowNode.getJobSource(), (CharSequence)flowNode.getPropsSource()));
            return prop;
        }
        return defaultProps;
    }

    private void parseFlow(FlowLoader flowLoader, File flowFile, String flowName, Flow flow) {
        FlowSpec flowSpec = new FlowSpec();
        flowSpec.setFlowName(flowName);
        List<Job> nodes = CollectionUtils.emptyIfNull((Collection)flow.getNodes()).stream().map(node -> this.parseJobFile(flowLoader, flowFile, flow, (Node)node)).collect(Collectors.toList());
        flowSpec.setJobs(nodes);
        Map<String, String> flowProperties = this.parseFlowProperties(flowLoader, flowName);
        flowSpec.setFlowProperties(flowProperties);
        this.flowJobs.put(flowName, flowSpec);
    }

    private Map<String, String> parseFlowProperties(FlowLoader flowLoader, String flowName) {
        Map flowMap = flowLoader.getFlowMap();
        if (!flowMap.containsKey(flowName)) {
            log.warn("flow map is null");
            return new HashMap<String, String>();
        }
        Flow flow = (Flow)flowMap.get(flowName);
        FlowProps flowProps = flow.getFlowProps(flowName + ".flow");
        if (Objects.isNull(flowProps)) {
            log.warn("flow props is null");
            return new HashMap<String, String>();
        }
        Props props = flowProps.getProps();
        if (Objects.isNull(props)) {
            log.warn("props is null");
            return new HashMap<String, String>();
        }
        return props.getFlattened();
    }

    private Job parseJobFile(FlowLoader flowLoader, File flowFile, Flow flow, Node node) {
        Props props = this.getNodeProps(flowLoader, flowFile, flow, node.getId());
        Map nodeProps = this.jobProperties.computeIfAbsent(flow.getId(), flowName -> new HashMap());
        nodeProps.put(node.getId(), props);
        Properties properties = props.toAllProperties();
        String type = properties.getProperty("type");
        JobType jobType = JobType.getByName(type);
        Job job = JobType.newJobInstance(jobType);
        job.setName(node.getId());
        if (StringUtils.isNotBlank((CharSequence)props.getSource())) {
            job.setJobFile(new File(this.projectDir, props.getSource()));
        }
        List fields = ReflectUtils.getPropertyFields((Object)job);
        fields.removeIf(field -> field.getDeclaringClass().equals(Job.class) && "type".equalsIgnoreCase(field.getName()));
        Enumeration<?> e = properties.propertyNames();
        HashSet<String> keys = new HashSet<String>();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            keys.add(key);
        }
        LinkedHashSet<String> sortKeys = AzkabanPackageParser.sortKeysWithSuffixHandling(keys);
        fields.forEach(field -> {
            ConfigProperty anno = field.getDeclaredAnnotation(ConfigProperty.class);
            if (anno == null) {
                return;
            }
            try {
                field.setAccessible(true);
                if (StringUtils.isNotBlank((CharSequence)anno.pattern())) {
                    Pattern pattern = Pattern.compile(anno.pattern());
                    List values = sortKeys.stream().filter(key -> pattern.matcher((CharSequence)key).matches()).map(properties::getProperty).collect(Collectors.toList());
                    field.set(job, values);
                }
                if (StringUtils.isNotBlank((CharSequence)anno.value())) {
                    String value = properties.getProperty(anno.value(), null);
                    Object objectValue = this.convertType((Field)field, anno, value);
                    field.set(job, objectValue);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        });
        job.processJobRelativeFiles();
        if (node.getType().equals(JobType.flow.name())) {
            ((FlowJob)job).setFlowName(node.getEmbeddedFlowId());
        }
        if (CollectionUtils.isEmpty(job.getDependencies())) {
            job.setDependencies(CollectionUtils.emptyIfNull((Collection)flow.getEdges()).stream().filter(edge -> StringUtils.equals((CharSequence)edge.getTargetId(), (CharSequence)node.getId())).map(Edge::getSourceId).collect(Collectors.toList()));
            LOGGER.info("flow: {}, job: {}, depends: {}", new Object[]{flow.getId(), job.getName(), job.getDependencies()});
        }
        return job;
    }

    public Props getJobProperties(String flowName, String nodeName) {
        return (Props)MapUtils.emptyIfNull((Map)((Map)MapUtils.emptyIfNull(this.jobProperties).get(flowName))).get(nodeName);
    }

    public Map<String, Map<String, Props>> getJobProperties() {
        return this.jobProperties;
    }

    public static LinkedHashSet<String> sortKeysWithSuffixHandling(Set<String> inputSet) {
        try {
            HashMap<String, SortKey> sortKeyMap = new HashMap<String, SortKey>();
            for (String key : inputSet) {
                SortKey sortKey = AzkabanPackageParser.extractSortKey(key);
                sortKeyMap.put(key, sortKey);
            }
            ArrayList<String> sortedList = new ArrayList<String>(inputSet);
            sortedList.sort((a, b) -> ((SortKey)sortKeyMap.get(a)).compareTo((SortKey)sortKeyMap.get(b)));
            return new LinkedHashSet<String>(sortedList);
        }
        catch (NumberFormatException e) {
            return new LinkedHashSet<String>(inputSet);
        }
    }

    private static SortKey extractSortKey(String key) {
        if ("command".equals(key)) {
            return new SortKey(0, null);
        }
        if (key.startsWith("command.")) {
            String suffix = key.substring("command.".length());
            int num = Integer.parseInt(suffix);
            return new SortKey(1, num);
        }
        return new SortKey(2, null);
    }

    public class FlowSpec {
        private String flowName;
        private List<Job> jobs;
        private Map<String, String> flowProperties;

        public void setFlowName(String flowName) {
            this.flowName = flowName;
        }

        public void setJobs(List<Job> jobs) {
            this.jobs = jobs;
        }

        public void setFlowProperties(Map<String, String> flowProperties) {
            this.flowProperties = flowProperties;
        }

        public String getFlowName() {
            return this.flowName;
        }

        public List<Job> getJobs() {
            return this.jobs;
        }

        public Map<String, String> getFlowProperties() {
            return this.flowProperties;
        }
    }

    private static class SortKey
    implements Comparable<SortKey> {
        private final int priority;
        private final Integer number;

        public SortKey(int priority, Integer number) {
            this.priority = priority;
            this.number = number;
        }

        @Override
        public int compareTo(SortKey other) {
            int priorityComp = Integer.compare(this.priority, other.priority);
            if (priorityComp != 0) {
                return priorityComp;
            }
            if (this.number != null && other.number != null) {
                return this.number.compareTo(other.number);
            }
            if (this.number != null) {
                return -1;
            }
            if (other.number != null) {
                return 1;
            }
            return 0;
        }
    }
}

