/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.util;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import java.util.Iterator;
import java.util.ServiceLoader;

public class ServiceLoaderUtil {
    private static final Logger logger = SecurityLogManager.getLogger(ServiceLoaderUtil.class);

    public static <T> T newInstance(Class<T> interfaceClazz, String fallbackClassName) {
        try {
            return ServiceLoader.load(interfaceClazz, interfaceClazz.getClassLoader()).iterator().next();
        }
        catch (Throwable e) {
            logger.warn("load spi {} failed {}", (Object)interfaceClazz.getName(), (Object)e);
            try {
                return (T)Class.forName(fallbackClassName, true, interfaceClazz.getClassLoader()).newInstance();
            }
            catch (Exception e2) {
                throw new RuntimeException("spi load failed, interface: " + interfaceClazz.getName() + " fallback " + fallbackClassName, e2);
            }
        }
    }

    public static <T> Iterator<T> newInstances(Class<T> interfaceClazz) {
        return ServiceLoader.load(interfaceClazz, interfaceClazz.getClassLoader()).iterator();
    }
}

